#
# RCSid:
#	$Id: autodep.mk,v 1.24 2006/03/02 18:47:14 sjg Exp $

# This module provides automagic dependency generation along the
# lines suggested in the GNU make.info
# The depend target is mainly for backwards compatability,
# dependencies are normally updated as part of compilation.

# set MKDEP=autodep and dep.mk will include us
.if !defined(_autodep_inc)
MKDEP=autodep
MKDEPCMD=autodep
_autodep_inc=1
# it does nothing if SRCS is not defined or is empty
.if defined(SRCS) && !empty(SRCS)
DEPSRCS?=${SRCS}
__depsrcs=${DEPSRCS:M*.c}
__depsrcs+=${DEPSRCS:M*.y}
__depsrcs+=${DEPSRCS:M*.l}
__depsrcs+=${DEPSRCS:M*.s}
__depsrcs+=${DEPSRCS:M*.S}
__depsrcs+=${DEPSRCS:M*.cc}
__depsrcs+=${DEPSRCS:M*.cpp}
__depsrcs+=${DEPSRCS:M*.C}
__depsrcs+=${DEPSRCS:M*.cxx}
__depsrcs+=${DEPSRCS:M*.pc}

.for s in ${__depsrcs}
${s:T:R}.d:	$s
.endfor

__depsrcs:=${__depsrcs:T:R:S/$/.d/g}
# we also need to handle makefiles where the .d's from __depsrcs 
# don't  match those from OBJS
__dependsrcs?= ${__depsrcs} ${OBJS:S/.o/.d/}
__dependsrcs:= ${__dependsrcs:O:u}

# clean up any .c files we may have generated
#__gensrcs:= ${DEPSRCS:M*.y} ${DEPSRCS:M*.l}
#CLEANFILES+= ${__gensrcs:T:R:S/$/.c/g}

# set this to -MMD to ignore /usr/include
# actually it ignores <> so may not be a great idea
CFLAGS_MD?=-MD 
# -MF etc not available on all gcc versions.
CFLAGS_MF?=-MF ${.PREFIX}.d -MT ${.PREFIX}.o
CFLAGS+= ${CFLAGS_MD} ${CFLAGS_MF}
RM?= rm

# watch out for people who don't use CPPFLAGS
CPPFLAGS_MD=${CFLAGS:M-[IUD]*} ${CPPFLAGS} 
CXXFLAGS_MD=${CXXFLAGS:M-[IUD]*} ${CPPFLAGS} 

# just in case these need to be different
CC_MD?=${CC}
CXX_MD?=${CXX}

# so we can do an explicit make depend, but not otherwise
.if make(depend)
.SUFFIXES:	.d

.if empty(CFLAGS_MD)
.y.d:
	@echo updating dependencies for $<
	@${YACC} ${YFLAGS} $<
	@${SHELL} -ec "${CC_MD} -M ${CPPFLAGS_MD} y.tab.c | sed '/:/s/^/$@ /' > $@" || { ${RM} -f y.tab.c $@; false; }
	@${RM} -f y.tab.c

.l.d:
	@echo updating dependencies for $<
	${LEX} ${LFLAGS} $<
	@${SHELL} -ec "${CC_MD} -M ${CPPFLAGS_MD} lex.yy.c | sed '/:/s/^/$@ /' > $@" || { ${RM} -f lex.yy.c $@; false; }
	@${RM} -f lex.yy.c

.c.d:
	@echo updating dependencies for $<
	@${SHELL} -ec "${CC_MD} -M ${CPPFLAGS_MD} $< | sed '/:/s/^/$@ /' > $@" || { ${RM} -f $@; false; }

.s.d .S.d:
	@echo updating dependencies for $<
	@${SHELL} -ec "${CC_MD} -M ${CPPFLAGS_MD} ${AINC} $< | sed '/:/s/^/$@ /' > $@" || { ${RM} -f $@; false; }

.cc.d .cpp.d .C.d .cxx.d:
	@echo updating dependencies for $<
	@${SHELL} -ec "${CXX_MD} -M ${CXXFLAGS_MD} $< | sed '/:/s/^/$@ /' > $@" || { ${RM} -f $@; false; }
.else
.y.d:
	${YACC} ${YFLAGS} $<
	${CC_MD} ${CFLAGS_MD:S/D//} ${CPPFLAGS_MD} y.tab.c > $@ || { ${RM} -f y.tab.c $@; false; }
	${RM} -f y.tab.c

.l.d:
	${LEX} ${LFLAGS} $<
	${CC_MD} ${CFLAGS_MD:S/D//} ${CPPFLAGS_MD} lex.yy.c > $@ || { ${RM} -f lex.yy.c $@; false; }
	${RM} -f lex.yy.c

.c.d:
	${CC_MD} ${CFLAGS_MD:S/D//} ${CPPFLAGS_MD} $< > $@ || { ${RM} -f $@; false; }

.s.d .S.d:
	${CC_MD} ${CFLAGS_MD:S/D//} ${CPPFLAGS_MD} ${AINC} $< > $@ || { ${RM} -f $@; false; }

.cc.d .cpp.d .C.d .cxx.d:
	${CXX_MD} ${CFLAGS_MD:S/D//} ${CXXFLAGS_MD} $< > $@ || { ${RM} -f $@; false; }
.endif

.if !target(depend)
depend: beforedepend .depend afterdepend _SUBDIRUSE

.depend:	${DEPSRCS} ${__dependsrcs}
.NOPATH:	${__dependsrcs}
.OPTIONAL:	${__dependsrcs}
.endif				# make(depend)

.if empty(CFLAGS_MD)
# make sure the .d's are generated/updated
${PROG} ${_LIBS}:	.depend
.endif
.endif

.ORDER:	beforedepend .depend afterdepend

.if ${.OBJDIR} != ${.CURDIR}
__depfiles= *.d
.else
__depfiles= ${__dependsrcs}
.endif

DEPCLEANFILES= .depend ${__depfiles} y.tab.d *.tmp.d

cleandir: cleanautodepend
cleanautodepend:
	${RM} -f ${DEPCLEANFILES}

CLEANFILES+= ${DEPCLEANFILES}

.if make(depend) || !(make(clean*) || make(obj) || make(*install) || make(install-*))
# this ensures we do the right thing if only building a shared or
# profiled lib
OBJ_EXTENSIONS?=.o .po .so .So
MDLIB_SED= -e '/:/s,^\([^\.:]*\)\.[psS]*o,${OBJ_EXTENSIONS:S,^,\1,},'
.ifdef NOMD_SED
.ifdef LIB
MD_SED=sed ${MDLIB_SED}
.else
MD_SED=cat
.endif
.else
# arrange to put some variable names into .depend
.ifdef LIB
MD_SED=sed ${MDLIB_SED}
.else
MD_SED=sed
.endif
SUBST_DEPVARS+= SB TOP BACKING SRC SRCDIR BASE BASEDIR
.for v in ${SUBST_DEPVARS}
.if defined(${v}) && !empty(${v})
MD_SED+= -e 's,${$v},$${$v},'
.endif
.endfor
.endif
.if (${MD_SED} == "sed")
MD_SED=cat
.endif

# this will be done whenever make finishes successfully
.if defined(__depsrcs) && !empty(__depsrcs)
.if ${MAKE_VERSION:U0:[1]:C/.*-//} < 20050530
.END:
.else
.END:	.depend
# we do not want to trigger building .d's just use them if they exist
.depend:	${__dependsrcs:@d@${exists($d):?$d:}@}
.endif
	-@(${MD_SED} ${__depfiles} && \
	sed -e '/:/s,^.*:,.OPTIONAL:,' \
	-e 's, [^ ][^ ]*\.c , ,g' ${__depfiles} 2>/dev/null) > .depend.new && \
	test -s .depend.new && mv .depend.new .depend; \
	${RM} -f .depend.new
.endif
.endif
.else
depend: beforedepend afterdepend _SUBDIRUSE
.endif

.if !target(beforedepend)
beforedepend:
.endif
.if !target(afterdepend)
afterdepend:
.endif

.endif
