/* ==== syscall.S ============================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by Chris Provenzano.
 * 4. The name of Chris Provenzano may not be used to endorse or promote 
 *	  products derived from this software without specific prior written
 *	  permission.
 *
 * THIS SOFTWARE IS PROVIDED BY CHRIS PROVENZANO ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL CHRIS PROVENZANO BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 *
 * Description : Machine dependent syscalls for decstation with r2000/r3000
 *
 *  1.00 93/08/14 proven
 *      -Started coding this file.
 */

#include <sys/syscall.h>
#include <mips/asm.h>

	ASMSTR("$Id: syscall-r2000-ultrix-4.2.S,v 1.51 1994/10/25 22:47:04 proven Exp $")

#define ABICALLS		/* XXX: Always true on NetBSD/mips* */

#ifdef ABICALLS
	.abicalls
#endif

/* ==========================================================================
 * machdep_sys_fork()
 */
LEAF(machdep_sys_fork)
#ifdef ABICALLS
	.set	noreorder
	.cpload	t9
	.set	reorder
#endif
	li	v0,SYS_fork
	syscall
	bne	a3,zero,machdep_error
	beq	v1,zero,1f
	move	v0,zero
1:
	j	ra
END(machdep_sys_fork)

/* ==========================================================================
 * machdep_sys_pipe()
 */
LEAF(machdep_sys_pipe)
#ifdef ABICALLS
	.set	noreorder
	.cpload	t9
	.set	reorder
#endif
	li	v0,SYS_pipe
	syscall
	bne	a3,zero,machdep_error
	sw	v0,0(a0)
	sw	v1,4(a0)
	li	v0,0
	j	ra
END(machdep_sys_pipe)

/* ==========================================================================
 * machdep_sys_fstat()
 */
LEAF(machdep_sys_fstat)
#ifdef ABICALLS
	.set	noreorder
	.cpload	t9
	.set	reorder
#endif
	li	v0,SYS___fstat13
	syscall
	bne	a3,zero,machdep_error
	j	ra
END(machdep_sys_fstat)

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value. Eventually I want to load the errno value directly
 * into pthread_run->error but until then ...
 */

machdep_error:
	negu	v0,v0		/* Return negative of errno value. */
	j ra
