#include <stdio.h>
#include <stdlib.h>
#include <machine/param.h>
#include <sys/types.h>
#include <sys/mbuf.h>
#include <sys/time.h>

extern char *__progname;

int
main(argc, argv)
	int argc;
	char **argv;
{
	int mbuflen, totlen;
	struct mbuf *b, *ob, *headbuf;
	int old_sum, new_sum;
	clock_t c[3];
	struct timeval t[3], odtv, ndtv;
	u_short seed[3];
	int count, i, loops;

	if (argc < 3) {
		fprintf(stderr, "Usage: %s <loops> <num> <size> [<size> ...]\n", __progname);
		exit(1);
	}

#ifdef SEED
	srand(SEED);
#else
	srand(time(NULL));
#endif
	seed[0] = rand() >> 8;
	seed[1] = rand() >> 8;
	seed[2] = rand() >> 8;
	seed48(seed);

	totlen = 0;
	b = ob = headbuf = NULL;

	loops = atoi(*++argv);
	argc--;

	count = atoi(*++argv);
	argc--;

	while (--argc) {
		mbuflen = atoi(*++argv);
		totlen += mbuflen;
		b = malloc(sizeof(struct mbuf));
		b->m_len = mbuflen;
		b->m_data = malloc((mbuflen + 15 + 4095) & ~4095);
		if (!headbuf) 
			headbuf = b;
		else 
			ob->m_next = b;
		ob = b;
	}

loop:
printf("align:");
	for (b = headbuf; b; b = b->m_next) {
		mbuflen = b->m_len;
		if (mbuflen == 0)
			continue;
		b->m_data = (char *)((u_long)b->m_data & ~15) +
			    (lrand48() & 15);
printf("%d", ((unsigned long)b->m_data) % 4);
		for (i = 0; i < mbuflen; i++)
			b->m_data[i] = lrand48() & 0xff;
	/*	printf("b->m_data = 0x%08x ", b->m_data);*/
	}  
printf(" ");

	old_sum = old_in_cksum(headbuf, totlen);
	new_sum = new_in_cksum(headbuf, totlen);

#ifndef NEW_PRINTING
	if (old_sum == new_sum)
		printf("old=%04x new=%04x ", old_sum, new_sum);
	else
		printf("ERROR! old=%04x new=%04x ", old_sum, new_sum);
	fflush(stdout);
#endif

	c[0] = clock();
	gettimeofday(&t[0], NULL);
	for (i = loops; i; i--)
		old_in_cksum(headbuf, totlen);
	c[1] = clock();
	gettimeofday(&t[1], NULL);
	for (i = loops; i; i--)
		new_in_cksum(headbuf, totlen);
	c[2] = clock();
	gettimeofday(&t[2], NULL);
	timersub(&t[1], &t[0], &odtv);
	timersub(&t[2], &t[1], &ndtv);

#ifndef NEW_PRINTING
	printf("oldt=%d.%06d sec (%d clocks) newt=%d.%06d sec (%d clocks)\n",
	    odtv.tv_sec, odtv.tv_usec, c[1] - c[0],
	    ndtv.tv_sec, ndtv.tv_usec, c[2] - c[1]);
#else
	if (old_sum != new_sum)
		printf("ERROR! ");
	printf("old=%04x oldt=%d.%06d sec (%d clocks) "
               "new=%04x newt=%d.%06d sec (%d clocks)\n",
	    old_sum, odtv.tv_sec, odtv.tv_usec, c[1] - c[0]
	    new_sum, ndtv.tv_sec, ndtv.tv_usec, c[2] - c[1]);
#endif
	fflush(stdout);

	if (--count)
		goto loop;

	exit(0);
}
