$NetBSD$
--- ztdummy/ztdummy.c.orig	2008-04-07 09:34:07.000000000 +0100
+++ ztdummy/ztdummy.c	2008-10-29 20:50:14.000000000 +0000
@@ -36,7 +36,12 @@
 #include <sys/uio.h>
 #include <sys/kernel.h>
 #include <sys/malloc.h>
+#ifdef __FreeBSD__
 #include <sys/module.h>
+#endif
+#ifdef __NetBSD__
+#include <sys/lkm.h>
+#endif
 
 #include <sys/conf.h>
 #include <sys/errno.h>
@@ -45,10 +50,12 @@
 
 #include "ztdummy.h"
 
-MODULE_VERSION(ztdummy, 1);
-
 MALLOC_DEFINE(M_ZTD, "ztdummy", "ztdummy interface data structures");
 
+#ifdef __FreeBSD__
+MODULE_VERSION(ztdummy, 1);
+#endif
+
 #ifndef timersub
 #define timersub(tvp, uvp, vvp)                                         \
         do {                                                            \
@@ -61,7 +68,12 @@
         } while (0)
 #endif
 
+#ifdef __FreeBSD__
 static struct callout_handle ztdummy_timer_handle = CALLOUT_HANDLE_INITIALIZER(&ztdummy_timer_handle);
+#endif
+#ifdef __NetBSD__
+static struct callout ztdummy_callout = CALLOUT_INITIALIZER;
+#endif
 
 static struct ztdummy *ztd;
 
@@ -124,7 +136,14 @@
 	if (ticks == 0)
 		goto loop;
 
+#ifdef __FreeBSD__
 	ztdummy_timer_handle = timeout(ztdummy_timer, NULL, ticks);
+#endif
+#ifdef __NetBSD__
+	callout_reset(&ztdummy_callout, ticks ? ticks : 1,
+		ztdummy_timer, NULL);
+#endif
+
 }
 
 static int ztdummy_initialize(struct ztdummy *ztd)
@@ -148,6 +167,9 @@
 static int ztdummy_attach(void )
 {
 
+#ifdef __NetBSD__
+	malloc_type_attach(M_ZTD);
+#endif
 	ztd = malloc(sizeof(struct ztdummy), M_ZTD, M_NOWAIT);
 	if (ztd == NULL) {
 		printf("ztdummy: Unable to allocate memory\n");
@@ -163,7 +185,12 @@
 	}
 
 	microtime(&basetime);
+#ifdef __FreeBSD__
 	ztdummy_timer_handle = timeout(ztdummy_timer, NULL, 1);
+#endif
+#ifdef __NetBSD__
+	callout_reset(&ztdummy_callout, 1, ztdummy_timer, NULL);
+#endif
     
 	if (debug)
 		printf("ztdummy: init() finished\n");
@@ -173,7 +200,13 @@
 
 static void cleanup_module(void)
 {
+#ifdef __FreeBSD__
 	untimeout(ztdummy_timer, NULL, ztdummy_timer_handle);
+#endif
+#ifdef __NetBSD__
+	callout_stop(&ztdummy_callout);
+	malloc_type_detach(M_ZTD);
+#endif
 	zt_unregister(&ztd->span);
 	free(ztd, M_ZTD);
 
@@ -182,7 +215,11 @@
 }
 
 
+#ifdef __FreeBSD__
 static int ztdummy_modevent(module_t mod,int  type, void*  data)
+#else
+static int ztdummy_modevent(struct lkm_table *lkmtp, int type)
+#endif
 {
 
 static int attached = 0;
@@ -211,7 +248,9 @@
 	 printf("ztdummy: unloaded\n");
 	 break;
 	 
+#ifdef __FreeBSD
  case MOD_SHUTDOWN:
+#endif
  default:
 	 return EOPNOTSUPP;
  }
@@ -219,8 +258,18 @@
 }
 
 
+#ifdef __FreeBSD__
 MODULE_DEPEND(ztdummy, zaptel, 1, 1, 1);
 DEV_MODULE(ztdummy, ztdummy_modevent, NULL);
+#endif
+#ifdef __NetBSD__
+/*MOD_DEV("ztdummy", "ztdummy", NULL, -1, NULL, -1)*/
+MOD_MISC("ztdummy");
 
-
-
+int
+mod_ztdummy_lkmentry(struct lkm_table *lkmtp, int cmd, int ver)
+{
+	DISPATCH(lkmtp, cmd, ver, ztdummy_modevent, ztdummy_modevent,
+			lkm_nofunc)
+}
+#endif
