$NetBSD$
--- wcfxs/wcfxsvar.h.orig	2006-05-29 10:24:31.000000000 +0100
+++ wcfxs/wcfxsvar.h	2008-10-29 20:18:13.000000000 +0000
@@ -1,5 +1,6 @@
 /* $Id: wcfxovar.h 707 2004-04-14 13:39:03Z gonzo $ */
 
+#ifdef __FreeBSD__
 struct wcfxs_data {
         int				*wc_writechunk;
         int				*wc_readchunk;
@@ -10,6 +11,18 @@
         bus_dma_tag_t			wc_write_tag;
         bus_dmamap_t			wc_write_dmamap;
 };
+#define READCHUNK(sc) ((sc)->wc_ldata.readchunk)
+#define WRITECHUNK(sc) ((sc)->wc_ldata.writechunk)
+#elif defined(__NetBSD__)
+struct wcfxs_dma {
+        uint32_t                *chunk;
+        bus_dmamap_t            dma_map;
+        bus_dma_segment_t       dma_seg;
+        int                     dma_nseg;
+};
+#define READCHUNK(sc) ((sc)->sc_read.chunk)
+#define WRITECHUNK(sc) ((sc)->sc_write.chunk)
+#endif
 
 struct wcfxs_desc {
 	char			*name;
@@ -23,6 +36,7 @@
 		struct wcfxs_desc	*device_info;
 };
 
+
 /* Locking stuff */
 #if 1
 #ifdef __FreeBSD__
