$NetBSD$
--- wcfxo/wcfxovar.h.orig	2005-08-26 18:25:35.000000000 +0100
+++ wcfxo/wcfxovar.h	2008-10-29 20:18:13.000000000 +0000
@@ -31,6 +31,7 @@
 
 /* $Id: wcfxovar.h 841 2004-06-16 15:48:58Z gonzo $ */
 
+#ifdef __FreeBSD__
 struct wcfxo_data {
         int 			*wc_writechunk;
         int			*wc_readchunk;
@@ -41,6 +42,18 @@
         bus_dma_tag_t           wc_write_tag;
         bus_dmamap_t            wc_write_dmamap;
 };
+#define READCHUNK(sc) ((sc)->wc_ldata.readchunk)
+#define WRITECHUNK(sc) ((sc)->wc_ldata.writechunk)
+#elif defined(__NetBSD__)
+struct wcfxo_dma {
+        uint32_t                *chunk;
+        bus_dmamap_t            dma_map;
+        bus_dma_segment_t       dma_seg;
+        int                     dma_nseg;
+};
+#define READCHUNK(sc) ((sc)->sc_read.chunk)
+#define WRITECHUNK(sc) ((sc)->sc_write.chunk)
+#endif
 
 struct wcfxo_desc {
 	char *name;
