#include <stdio.h>
#include <string.h>
#include <sys/stdint.h>

#include "util.h"

int batch = 0;

static int
mygetline(char *buf, size_t n)
{
	buf[0] = '\0';
	if (fgets(buf,n,stdin) == NULL)
		return 0;
	n = strlen(buf);
	while (n>0 && buf[n-1] == '\n')
		buf[--n] = '\0';
	return 1;
}

int getint(long *vp)
{
	long v;
	if (scanf("%ld",&v) != 1) {
		fprintf(stderr,"getint: input error\n");
		return 0;
	}
	*vp = v;
	return 1;
}

int getuint(unsigned long *vp)
{
	unsigned long v;
	if (scanf("%lu",&v) != 1) {
		fprintf(stderr,"getuint: input error\n");
		return 0;
	}
	*vp = v;
	return 1;
}

int getbuf(char *b, size_t n)
{
	char buf[100];

	if (!mygetline(buf,sizeof(buf))) {
		fprintf(stderr,"getbuf: input error\n");
		return 0;
	}

	strncpy(b, buf, n);
	return 1;
}

int getflags(unsigned long *vp, const char *temp)
{
	char buf[100], *p, *l;
	const char *t, *e;
	size_t n;
	unsigned long v, m;

	if (!mygetline(buf,sizeof(buf))) {
		fprintf(stderr,"getbuf: input error\n");
		return 0;
	}

	v = 0;
	for ((p = strtok_r(buf,",",&l)); p; p = strtok_r(NULL,",",&l)) {
		for (t=temp,m=1; t; t=e,m<<=1) {
			e = strchr(t, ',');
			if (e) {
				n = e-t;
				e = e+1;
			} else {
				n = strlen(t);
			}

			if (n > 0 && strlen(p) == n && strncmp(p,t,n) == 0) {
				v |= m;
				break;
			}
		}
	}

	*vp = v;
	return 1;
}

static void print_menu(const struct mitem m[], int n)
{
	int i;
	for (i=0; i<n; ++i)
		printf("%c       %s\n",m[i].key,m[i].descr);
}

static void print_keys(const struct mitem m[], int n)
{
	int i;
	printf("[");
	for (i=0; i<n; ++i)
		printf("%c",m[i].key);
	printf("] type ? to display menu\n");
}

int menu(const struct mitem m[], int n)
{
	int i, c;

	if (!batch) print_keys(m,n);
	while ((c = getchar()) != EOF) {
		switch (c) {
		case ' ':
		case '\n':
			break;
		case '?':
			print_menu(m,n);
			print_keys(m,n);
			break;
		default:
			for (i=0; i<n; ++i) {
				if (m[i].key == c)
					return c;
			}
			break;
		}
	}
	return c;
}

void endmenu(void)
{
	int c;

	while ((c = getchar()) != EOF) {
		if (c == '\n')
			break;
	}
}


int yesno(const char *prompt)
{
	char buf[200];

	do {
		printf("%s: (Y/N)",prompt);
		if (fgets(buf, sizeof(buf), stdin) == NULL)
			break;
	} while (buf[0] == '\n');

	return buf[0] == 'y' || buf[0] == 'Y';
}
