struct part_mem {
	struct part_mem *next;
	uint32_t dskblk;
	int modified;
	char data[512];
};

struct lseg_mem {
	struct lseg_mem *next;
	uint32_t dskblk;
	int modified;
	char data[512];
};

struct fsh_mem {
	struct fsh_mem *next;
	uint32_t dskblk;
	int modified;
	struct lseg_mem *lsegs;
	char data[512];
};

struct badb_mem {
	struct badb_mem *next;
	uint32_t dskblk;
	int modified;
	char data[512];
};

struct rdb_mem {
	uint32_t dskblk;
	int modified;
	struct part_mem *parts;
	struct fsh_mem *fshs;
	struct lseg_mem *drvini;
	struct badb_mem *badblocks;
	char data[512];
};

struct diskgeometry {
	int blocks;
	int sectors;
	int heads;
	int blocksize;
};

void free_rdb(struct rdb_mem *);
struct rdb_mem *init_rdb(int, struct diskgeometry *);
void size_rdb(struct rdb_mem *, struct diskgeometry *);
struct rdb_mem *load_rdb(int);
int erase_rdb(int, struct rdb_mem *);
int write_rdb(int, struct rdb_mem *);
int edit_rdb(struct rdb_mem *, struct diskgeometry *);

void display_all(struct rdb_mem *);

struct part_mem *find_part(struct rdb_mem *, uint32_t);
uint32_t find_blk(struct rdb_mem *);

struct part_mem *
add_part(struct rdb_mem *, int , struct part_mem *, uint32_t);
int delete_part(struct rdb_mem *, struct part_mem *);
int edit_part(struct part_mem *, struct rdb_mem *);

void print_disktab(struct rdb_mem *);
