#include <unistd.h>
#include <err.h>
#include <stdio.h>

#include "io.h"

extern int debug;

int
read_block(int fd, void *buf, uint32_t blk, char *what)
{
	if (debug)
		fprintf(stderr,"read_block(%lu,%s)\n",(unsigned long)blk,what);
	if (lseek(fd, blk * (off_t)512, SEEK_SET) < 0) {
		err(1, "read_block lseek %s", what);
	}
	if (read(fd, buf, 512) != 512) {
		err(1, "read_block read %s", what);
	}
	return 0;
}

int
write_block(int fd, void *buf, uint32_t blk, char *what)
{
	if (debug)
		fprintf(stderr,"write_block(%lu,%s)\n",(unsigned long)blk,what);
	if (lseek(fd, blk * (off_t)512, SEEK_SET) < 0) {
		warn("write_block lseek %s", what);
		return -1;
	}
	if (write(fd, buf, 512) != 512) {
		warn("write_block write %s", what);
		return -1;
	}
	return 0;
}
