/**
 * KCursor class implementation
 * kcursor.cpp
 *
 * Copyright (C) 1998 Kurt Granroth <granroth@kde.org>
 */
#include <kcursor.h>

#include <kapp.h>
#include <qbitmap.h>

KCursor::KCursor()
{
}

QCursor KCursor::handCursor()
{
	static QCursor *hand_cursor = 0;

	if (hand_cursor == 0)
	{
		if (KApplication::style() == WindowsStyle)
		{
			unsigned char HAND_BITS[] = {
				0x80, 0x01, 0x00, 0x40, 0x02, 0x00, 0x40, 0x02, 0x00, 0x40, 0x02,
				0x00, 0x40, 0x02, 0x00, 0x40, 0x02, 0x00, 0x40, 0x1e, 0x00, 0x40,
				0xf2, 0x00, 0x40, 0x92, 0x01, 0x70, 0x92, 0x02, 0x50, 0x92, 0x04,
				0x48, 0x80, 0x04, 0x48, 0x00, 0x04, 0x48, 0x00, 0x04, 0x08, 0x00,
				0x04, 0x08, 0x00, 0x04, 0x10, 0x00, 0x04, 0x10, 0x00, 0x04, 0x20,
				0x00, 0x02, 0x40, 0x00, 0x02, 0x40, 0x00, 0x01, 0xc0, 0xff, 0x01};
			unsigned char HAND_MASK_BITS[] = {
				0x80, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03,
				0x00, 0xc0, 0x03, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x1f, 0x00, 0xc0,
				0xff, 0x00, 0xc0, 0xff, 0x01, 0xf0, 0xff, 0x03, 0xf0, 0xff, 0x07,
				0xf8, 0xff, 0x07, 0xf8, 0xff, 0x07, 0xf8, 0xff, 0x07, 0xf8, 0xff,
				0x07, 0xf8, 0xff, 0x07, 0xf0, 0xff, 0x07, 0xf0, 0xff, 0x07, 0xe0,
				0xff, 0x03, 0xc0, 0xff, 0x03, 0xc0, 0xff, 0x01, 0xc0, 0xff, 0x01};
			QBitmap hand_bitmap(22, 22, HAND_BITS, true); 
			QBitmap hand_mask(22, 22, HAND_MASK_BITS, true); 
			hand_cursor = new QCursor(hand_bitmap, hand_mask, 7, 0);
		}
		else
		{
			unsigned char HAND_BITS[] = {
				0x00, 0x00, 0xfe, 0x01, 0x01, 0x02, 0x7e, 0x04, 0x08, 0x08, 0x70,
				0x08, 0x08, 0x08, 0x70, 0x14, 0x08, 0x22, 0x30, 0x41, 0xc0, 0x20,
				0x40, 0x12, 0x80, 0x08, 0x00, 0x05, 0x00, 0x02, 0x00, 0x00};
			unsigned char HAND_MASK_BITS[] = {
				0xfe, 0x01, 0xff, 0x03, 0xff, 0x07, 0xff, 0x0f, 0xfe, 0x1f, 0xf8,
				0x1f, 0xfc, 0x1f, 0xf8, 0x3f, 0xfc, 0x7f, 0xf8, 0xff, 0xf0, 0x7f,
				0xe0, 0x3f, 0xc0, 0x1f, 0x80, 0x0f, 0x00, 0x07, 0x00, 0x02};
			QBitmap hand_bitmap(16, 16, HAND_BITS, true); 
			QBitmap hand_mask(16, 16, HAND_MASK_BITS, true); 
			hand_cursor = new QCursor(hand_bitmap, hand_mask, 0, 0);
		}
	}

	CHECK_PTR(hand_cursor);
	return *hand_cursor;
}

/**
 * All of the follow functions will return the Qt default for now regardless
 * of the style.  This will change at some later date
 */
QCursor KCursor::arrowCursor()
{
	return ::arrowCursor;
}


QCursor KCursor::upArrowCursor()
{
	return ::upArrowCursor;
}


QCursor KCursor::crossCursor()
{
	return ::crossCursor;
}


QCursor KCursor::waitCursor()
{
	return ::waitCursor;
}


QCursor KCursor::ibeamCursor()
{
	return ::ibeamCursor;
}


QCursor KCursor::sizeVerCursor()
{
	return ::sizeVerCursor;
}


QCursor KCursor::sizeHorCursor()
{
	return ::sizeHorCursor;
}


QCursor KCursor::sizeBDiagCursor()
{
	return ::sizeBDiagCursor;
}


QCursor KCursor::sizeFDiagCursor()
{
	return ::sizeFDiagCursor;
}


QCursor KCursor::sizeAllCursor()
{
	return ::sizeAllCursor;
}


QCursor KCursor::blankCursor()
{
	return ::blankCursor;
}

