/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/ktor/network/tls/EncryptionInfo;", "", "serverPublic", "Ljava/security/PublicKey;", "clientPublic", "clientPrivate", "Ljava/security/PrivateKey;", "(Ljava/security/PublicKey;Ljava/security/PublicKey;Ljava/security/PrivateKey;)V", "getClientPrivate", "()Ljava/security/PrivateKey;", "getClientPublic", "()Ljava/security/PublicKey;", "getServerPublic", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ktor-network-tls"})
public final class EncryptionInfo {
    @NotNull
    private final PublicKey serverPublic;
    @NotNull
    private final PublicKey clientPublic;
    @NotNull
    private final PrivateKey clientPrivate;

    public EncryptionInfo(@NotNull PublicKey serverPublic, @NotNull PublicKey clientPublic, @NotNull PrivateKey clientPrivate) {
        Intrinsics.checkNotNullParameter((Object)serverPublic, (String)"serverPublic");
        Intrinsics.checkNotNullParameter((Object)clientPublic, (String)"clientPublic");
        Intrinsics.checkNotNullParameter((Object)clientPrivate, (String)"clientPrivate");
        this.serverPublic = serverPublic;
        this.clientPublic = clientPublic;
        this.clientPrivate = clientPrivate;
    }

    @NotNull
    public final PublicKey getServerPublic() {
        return this.serverPublic;
    }

    @NotNull
    public final PublicKey getClientPublic() {
        return this.clientPublic;
    }

    @NotNull
    public final PrivateKey getClientPrivate() {
        return this.clientPrivate;
    }

    @NotNull
    public final PublicKey component1() {
        return this.serverPublic;
    }

    @NotNull
    public final PublicKey component2() {
        return this.clientPublic;
    }

    @NotNull
    public final PrivateKey component3() {
        return this.clientPrivate;
    }

    @NotNull
    public final EncryptionInfo copy(@NotNull PublicKey serverPublic, @NotNull PublicKey clientPublic, @NotNull PrivateKey clientPrivate) {
        Intrinsics.checkNotNullParameter((Object)serverPublic, (String)"serverPublic");
        Intrinsics.checkNotNullParameter((Object)clientPublic, (String)"clientPublic");
        Intrinsics.checkNotNullParameter((Object)clientPrivate, (String)"clientPrivate");
        return new EncryptionInfo(serverPublic, clientPublic, clientPrivate);
    }

    public static /* synthetic */ EncryptionInfo copy$default(EncryptionInfo encryptionInfo, PublicKey publicKey, PublicKey publicKey2, PrivateKey privateKey, int n, Object object) {
        if ((n & 1) != 0) {
            publicKey = encryptionInfo.serverPublic;
        }
        if ((n & 2) != 0) {
            publicKey2 = encryptionInfo.clientPublic;
        }
        if ((n & 4) != 0) {
            privateKey = encryptionInfo.clientPrivate;
        }
        return encryptionInfo.copy(publicKey, publicKey2, privateKey);
    }

    @NotNull
    public String toString() {
        return "EncryptionInfo(serverPublic=" + this.serverPublic + ", clientPublic=" + this.clientPublic + ", clientPrivate=" + this.clientPrivate + ')';
    }

    public int hashCode() {
        int result = this.serverPublic.hashCode();
        result = result * 31 + this.clientPublic.hashCode();
        result = result * 31 + this.clientPrivate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptionInfo)) {
            return false;
        }
        EncryptionInfo encryptionInfo = (EncryptionInfo)other;
        if (!Intrinsics.areEqual((Object)this.serverPublic, (Object)encryptionInfo.serverPublic)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientPublic, (Object)encryptionInfo.clientPublic)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientPrivate, (Object)encryptionInfo.clientPrivate);
    }
}

