/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.tags;

import io.kotest.engine.tags.Token;
import io.kotest.engine.tags.TokenType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/kotest/engine/tags/Lexer;", "", "input", "", "(Ljava/lang/String;)V", "pointer", "", "eos", "", "lex", "", "Lio/kotest/engine/tags/Token;", "next", "", "peek", "readIdentifier", "char", "kotest-framework-engine"})
public final class Lexer {
    @NotNull
    private final String input;
    private int pointer;

    public Lexer(@NotNull String input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        this.input = input2;
    }

    private final char next() {
        int n = this.pointer;
        this.pointer = n + 1;
        return this.input.charAt(n);
    }

    private final boolean eos() {
        return this.pointer == this.input.length();
    }

    private final char peek() {
        return this.input.charAt(this.pointer);
    }

    private final Token readIdentifier(char c) {
        String lexeme = String.valueOf(c);
        while (!this.eos() && this.peek() != ' ' && this.peek() != ')' && this.peek() != '(') {
            lexeme = lexeme + this.next();
        }
        return new Token(lexeme, TokenType.Identifier);
    }

    @NotNull
    public final List<Token> lex() {
        List tokens = new ArrayList();
        while (!this.eos()) {
            char c = this.next();
            Object token = c == '!' ? new Token("!", TokenType.ExclamationMark) : (c == '&' ? new Token("&", TokenType.Ampersand) : (c == ')' ? new Token(")", TokenType.CloseParen) : (c == '(' ? new Token("(", TokenType.OpenParen) : (c == '|' ? new Token("|", TokenType.Pipe) : (c == ' ' ? null : this.readIdentifier(c))))));
            if (token == null) continue;
            tokens.add(token);
        }
        return tokens;
    }
}

