/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.maven.plugin.surefire.report.FileReporter;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.surefire.booter.DumpErrorSingleton;
import org.apache.maven.surefire.report.ReportEntry;

public class ConsoleOutputFileReporter
implements TestcycleConsoleOutputReceiver {
    private static final int STREAM_BUFFER_SIZE = 16384;
    private static final int OPEN = 0;
    private static final int CLOSED_TO_REOPEN = 1;
    private static final int CLOSED = 2;
    private final File reportsDirectory;
    private final String reportNameSuffix;
    private final AtomicStampedReference<FilterOutputStream> fileOutputStream = new AtomicStampedReference<Object>(null, 0);
    private final ReentrantLock lock = new ReentrantLock();
    private volatile String reportEntryName;

    public ConsoleOutputFileReporter(File reportsDirectory, String reportNameSuffix) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
    }

    @Override
    public void testSetStarting(ReportEntry reportEntry) {
        this.lock.lock();
        try {
            this.closeNullReportFile(reportEntry);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void testSetCompleted(ReportEntry report) {
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.closeReportFile();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        this.lock.lock();
        try {
            int[] status = new int[1];
            FilterOutputStream os = this.fileOutputStream.get(status);
            if (status[0] != 2) {
                if (os == null) {
                    if (!this.reportsDirectory.exists()) {
                        this.reportsDirectory.mkdirs();
                    }
                    File file = FileReporter.getReportFile(this.reportsDirectory, this.reportEntryName, this.reportNameSuffix, "-output.txt");
                    os = new BufferedOutputStream(new FileOutputStream(file), 16384);
                    this.fileOutputStream.set(os, 0);
                }
                os.write(buf, off, len);
            }
        }
        catch (IOException e) {
            DumpErrorSingleton.getSingleton().dumpException((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void closeNullReportFile(ReportEntry reportEntry) {
        try {
            this.close(true);
        }
        catch (IOException ignored) {
            DumpErrorSingleton.getSingleton().dumpException((Throwable)ignored);
        }
        finally {
            this.reportEntryName = reportEntry.getName();
        }
    }

    private void closeReportFile() {
        try {
            this.close(false);
        }
        catch (IOException ignored) {
            DumpErrorSingleton.getSingleton().dumpException((Throwable)ignored);
        }
    }

    private void close(boolean closeReattempt) throws IOException {
        int[] status = new int[1];
        FilterOutputStream os = this.fileOutputStream.get(status);
        if (status[0] != 2) {
            this.fileOutputStream.set(null, closeReattempt ? 1 : 2);
            if (os != null && status[0] == 0) {
                os.close();
            }
        }
    }
}

