/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.core.internal;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.internal.FormatPomModel;
import com.pinterest.ktlint.core.internal.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.pom.PomModel;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeCopyHandler;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"extractCompilerExtension", "Ljava/nio/file/Path;", "initPsiFileFactory", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFileFactory;", "isFromCli", "", "enableASTMutations", "", "Lorg/jetbrains/kotlin/com/intellij/mock/MockProject;", "ktlint-core"})
public final class KotlinPsiFileFactoryKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final PsiFileFactory initPsiFileFactory(boolean isFromCli) {
        Logger.setFactory(LoggerFactory.class);
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)MessageCollector.Companion.getNONE());
        if (isFromCli && Intrinsics.areEqual((Object)System.getProperty("java.specification.version"), (Object)"1.8")) {
            Path extensionPath = KotlinPsiFileFactoryKt.extractCompilerExtension();
            compilerConfiguration.put(CLIConfigurationKeys.INTELLIJ_PLUGIN_ROOT, (Object)((Object)extensionPath.toAbsolutePath()).toString());
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable disposable2 = disposable;
        try {
            MockProject project = (MockProject)KotlinCoreEnvironment.Companion.createForProduction(disposable2, compilerConfiguration, EnvironmentConfigFiles.JVM_CONFIG_FILES).getProject();
            KotlinPsiFileFactoryKt.enableASTMutations(project);
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)psiFileFactory, (String)"getInstance(project)");
            PsiFileFactory psiFileFactory2 = psiFileFactory;
            return psiFileFactory2;
        }
        finally {
            disposable2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Path extractCompilerExtension() {
        Closeable closeable = KtLint.class.getResourceAsStream("/META-INF/extensions/compiler.xml");
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Path tempDir = Files.createTempDirectory("ktlint", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Object object = tempDir.resolve("META-INF/extensions");
            Path it = object;
            boolean bl2 = false;
            Files.createDirectories(it, new FileAttribute[0]);
            Path extensionsDir = object;
            File file = extensionsDir.resolve("compiler.xml").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"extensionsDir.resolve(\"compiler.xml\").toFile()");
            object = file;
            object = new FileOutputStream((File)object);
            int n = 8192;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream it2 = (BufferedOutputStream)object;
                boolean bl3 = false;
                InputStream inputStream = input;
                Intrinsics.checkNotNull((Object)inputStream);
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it2, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)tempDir, (String)"tempDir");
            Path path = tempDir;
            return path;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void enableASTMutations(MockProject $this$enableASTMutations) {
        String extensionPoint = "org.jetbrains.kotlin.com.intellij.treeCopyHandler";
        String extensionClassName = TreeCopyHandler.class.getName();
        ExtensionsArea[] extensionsAreaArray = new ExtensionsArea[]{(ExtensionsArea)$this$enableASTMutations.getExtensionArea(), Extensions.getRootArea()};
        for (ExtensionsArea area : extensionsAreaArray) {
            if (area.hasExtensionPoint(extensionPoint)) continue;
            area.registerExtensionPoint(extensionPoint, extensionClassName, ExtensionPoint.Kind.INTERFACE);
        }
        $this$enableASTMutations.registerService(PomModel.class, (Object)new FormatPomModel());
    }
}

