/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.sip.SipMessage;
import io.pkts.packet.sip.SipPacket;
import io.pkts.packet.sip.impl.SipParser;
import io.pkts.packet.sip.impl.SipRequestPacketImpl;
import io.pkts.packet.sip.impl.SipResponsePacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public final class SIPFramer
implements Framer<TransportPacket, SipPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.SIP;
    }

    @Override
    public SipPacket frame(TransportPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        SipMessage sip = SipParser.frame((Buffer)buffer);
        if (sip.isRequest()) {
            return new SipRequestPacketImpl(parent, sip.toRequest());
        }
        return new SipResponsePacketImpl(parent, sip.toResponse());
    }

    @Override
    public boolean accept(Buffer data) throws IOException {
        return SIPFramer.couldBeSipMessage(data);
    }

    public static boolean couldBeSipMessage(Buffer data) throws IOException {
        if (data.getReadableBytes() < 4) {
            return false;
        }
        byte a = data.getByte(0);
        byte b = data.getByte(1);
        byte c = data.getByte(2);
        byte d = data.getByte(3);
        return a == 83 && b == 73 && c == 80 || a == 73 && b == 78 && c == 86 && d == 73 || a == 65 && b == 67 && c == 75 || a == 66 && b == 89 && c == 69 || a == 79 && b == 80 && c == 84 && d == 73 || a == 67 && b == 65 && c == 78 && d == 67 || a == 77 && b == 69 && c == 83 && d == 83 || a == 82 && b == 69 && c == 71 && d == 73 || a == 73 && b == 78 && c == 70 && d == 79 || a == 80 && b == 82 && c == 65 && d == 67 || a == 83 && b == 85 && c == 66 && d == 83 || a == 78 && b == 79 && c == 84 && d == 73 || a == 85 && b == 80 && c == 68 && d == 65 || a == 82 && b == 69 && c == 70 && d == 69 || a == 80 && b == 85 && c == 66 && d == 76;
    }
}

