/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.impl.ImmutableSipMessage;
import io.pkts.packet.sip.impl.SipResponseLine;
import java.util.List;

public class ImmutableSipResponse
extends ImmutableSipMessage
implements SipResponse {
    protected ImmutableSipResponse(Buffer message, SipResponseLine initialLine, List<SipHeader> headers, short indexOfTo, short indexOfFrom, short indexOfCSeq, short indexOfCallId, short indexOfMaxForwards, short indexOfVia, short indexOfRoute, short indexOfRecordRoute, short indexOfContact, Buffer body) {
        super(message, initialLine, headers, indexOfTo, indexOfFrom, indexOfCSeq, indexOfCallId, indexOfMaxForwards, indexOfVia, indexOfRoute, indexOfRecordRoute, indexOfContact, body);
    }

    @Override
    public Buffer getMethod() throws SipParseException {
        CSeqHeader cseq = this.getCSeqHeader();
        if (cseq != null) {
            return cseq.getMethod();
        }
        return null;
    }

    @Override
    public SipResponse.Builder copy() {
        SipResponseLine responseLine = this.getInitialLineAsObject().toResponseLine();
        SipResponse.Builder builder = SipResponse.withStatusCode(responseLine.getStatusCode());
        builder.withReasonPhrase(responseLine.getReason());
        builder.withHeaders(this.getAllHeaders());
        builder.withBody(this.getContent());
        return builder;
    }

    @Override
    public int getStatus() {
        return this.getInitialLineAsObject().toResponseLine().getStatusCode();
    }

    @Override
    public Buffer getReasonPhrase() {
        return this.getInitialLineAsObject().toResponseLine().getReason();
    }

    @Override
    public final SipResponse clone() {
        return this;
    }
}

