/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow.rc;

import com.google.common.base.Strings;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.workflow.rc.AbstractStagingRcActionMojo;

@Mojo(name="rc-promote", requiresProject=false, requiresDirectInvocation=true, requiresOnline=true)
public class RcPromoteToStageProfileMojo
extends AbstractStagingRcActionMojo {
    @Parameter(property="buildPromotionProfileId", required=true)
    private String buildPromotionProfileId;

    protected String getBuildPromotionProfileId() throws MojoExecutionException {
        if (this.buildPromotionProfileId == null) {
            throw new MojoExecutionException("The staging staging build promotion profile ID to promote to is not defined! (use \"-DbuildPromotionProfileId=foo\" on CLI)");
        }
        return this.buildPromotionProfileId;
    }

    @Override
    public void doExecute(StagingWorkflowV2Service stagingWorkflow) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("RC-Promoting staging repository with IDs=" + Arrays.toString(this.getStagingRepositoryIds()) + " to build profile ID=\"" + this.getBuildPromotionProfileId() + "\""));
        String promotionGroupId = stagingWorkflow.promoteStagingRepositories(this.getDescriptionWithDefaultsForAction(StagingAction.PROMOTE), this.getBuildPromotionProfileId(), this.getStagingRepositoryIds());
        if (Strings.isNullOrEmpty((String)promotionGroupId)) {
            this.getLog().info((CharSequence)"Promoted, but created promotion group ID unknown (needs Nexus Pro version 2.4+).");
        } else {
            this.getLog().info((CharSequence)("Promoted, created promotion group with ID " + promotionGroupId));
        }
    }
}

