/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkClient
implements StreamConsumer {
    private final DefaultReporterFactory providerReporterFactory;
    private final Map<Integer, RunListener> testSetReporters = Collections.synchronizedMap(new HashMap());
    private final Properties testVmSystemProperties;
    private volatile boolean saidGoodBye = false;

    public ForkClient(DefaultReporterFactory providerReporterFactory, Properties testVmSystemProperties) {
        this.providerReporterFactory = providerReporterFactory;
        this.testVmSystemProperties = testVmSystemProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeLine(String s) {
        try {
            if (s.length() == 0) {
                return;
            }
            byte operationId = (byte)s.charAt(0);
            int commma = s.indexOf(",", 3);
            if (commma < 0) {
                System.out.println(s);
                return;
            }
            Integer channelNumber = Integer.parseInt(s.substring(2, commma), 16);
            int rest = s.indexOf(",", commma);
            String remaining = s.substring(rest + 1);
            switch (operationId) {
                case 49: {
                    this.getOrCreateReporter(channelNumber).testSetStarting(this.createReportEntry(remaining));
                    break;
                }
                case 50: {
                    this.getOrCreateReporter(channelNumber).testSetCompleted(this.createReportEntry(remaining));
                    break;
                }
                case 53: {
                    this.getOrCreateReporter(channelNumber).testStarting(this.createReportEntry(remaining));
                    break;
                }
                case 54: {
                    this.getOrCreateReporter(channelNumber).testSucceeded(this.createReportEntry(remaining));
                    break;
                }
                case 56: {
                    this.getOrCreateReporter(channelNumber).testFailed(this.createReportEntry(remaining));
                    break;
                }
                case 57: {
                    this.getOrCreateReporter(channelNumber).testSkipped(this.createReportEntry(remaining));
                    break;
                }
                case 55: {
                    this.getOrCreateReporter(channelNumber).testError(this.createReportEntry(remaining));
                    break;
                }
                case 71: {
                    this.getOrCreateReporter(channelNumber).testAssumptionFailure(this.createReportEntry(remaining));
                    break;
                }
                case 73: {
                    int keyEnd = remaining.indexOf(",");
                    StringWriter key = new StringWriter();
                    StringWriter value = new StringWriter();
                    StringUtils.unescapeJava((StringWriter)key, (String)remaining.substring(0, keyEnd));
                    StringUtils.unescapeJava((StringWriter)value, (String)remaining.substring(keyEnd + 1));
                    Properties properties = this.testVmSystemProperties;
                    synchronized (properties) {
                        this.testVmSystemProperties.put(key, value);
                        break;
                    }
                }
                case 51: {
                    byte[] bytes = new byte[remaining.length() * 2];
                    int len = StringUtils.unescapeJava((byte[])bytes, (String)remaining);
                    this.getOrCreateConsoleOutputReceiver(channelNumber).writeTestOutput(bytes, 0, len, true);
                    break;
                }
                case 52: {
                    byte[] bytes = new byte[remaining.length() * 2];
                    int len = StringUtils.unescapeJava((byte[])bytes, (String)remaining);
                    this.getOrCreateConsoleOutputReceiver(channelNumber).writeTestOutput(bytes, 0, len, false);
                    break;
                }
                case 72: {
                    this.getOrCreateConsoleLogger(channelNumber).info(this.createConsoleMessage(remaining));
                    break;
                }
                case 90: {
                    this.saidGoodBye = true;
                    break;
                }
                default: {
                    System.out.println(s);
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println(s);
        }
        catch (ReporterException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void consumeMultiLineContent(String s) throws IOException {
        String s1;
        BufferedReader stringReader = new BufferedReader(new StringReader(s));
        while ((s1 = stringReader.readLine()) != null) {
            this.consumeLine(s1);
        }
    }

    private String createConsoleMessage(String remaining) {
        return this.unescape(remaining);
    }

    private ReportEntry createReportEntry(String untokenized) {
        StringTokenizer tokens = new StringTokenizer(untokenized, ",");
        try {
            String source = this.nullableCsv(tokens.nextToken());
            String name = this.nullableCsv(tokens.nextToken());
            String group = this.nullableCsv(tokens.nextToken());
            String message = this.nullableCsv(tokens.nextToken());
            String elapsedStr = tokens.nextToken();
            Integer elapsed = "null".equals(elapsedStr) ? null : Integer.decode(elapsedStr);
            StackTraceWriter stackTraceWriter = tokens.hasMoreTokens() ? this.deserializeStackStraceWriter(tokens) : null;
            return CategorizedReportEntry.reportEntry((String)source, (String)name, (String)group, (StackTraceWriter)stackTraceWriter, (Integer)elapsed, (String)message);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(untokenized, e);
        }
    }

    private StackTraceWriter deserializeStackStraceWriter(StringTokenizer tokens) {
        String stackTraceMessage = this.nullableCsv(tokens.nextToken());
        String stackTrace = tokens.hasMoreTokens() ? this.nullableCsv(tokens.nextToken()) : null;
        DeserializedStacktraceWriter stackTraceWriter = stackTrace != null ? new DeserializedStacktraceWriter(stackTraceMessage, stackTrace) : null;
        return stackTraceWriter;
    }

    private String nullableCsv(String source) {
        if ("null".equals(source)) {
            return null;
        }
        return this.unescape(source);
    }

    private String unescape(String source) {
        StringWriter stringWriter = new StringWriter(source.length());
        StringUtils.unescapeJava((StringWriter)stringWriter, (String)source);
        return stringWriter.getBuffer().toString();
    }

    public RunListener getReporter(Integer channelNumber) {
        return this.testSetReporters.get(channelNumber);
    }

    private RunListener getOrCreateReporter(Integer channelNumber) {
        RunListener reporter = this.testSetReporters.get(channelNumber);
        if (reporter == null) {
            reporter = this.providerReporterFactory.createReporter();
            this.testSetReporters.put(channelNumber, reporter);
        }
        return reporter;
    }

    private ConsoleOutputReceiver getOrCreateConsoleOutputReceiver(Integer channelNumber) {
        return (ConsoleOutputReceiver)this.getOrCreateReporter(channelNumber);
    }

    private ConsoleLogger getOrCreateConsoleLogger(Integer channelNumber) {
        return (ConsoleLogger)this.getOrCreateReporter(channelNumber);
    }

    public void close() {
        if (!this.saidGoodBye) {
            throw new RuntimeException("The forked VM terminated without saying properly goodbye. VM crash or System.exit called ?");
        }
    }
}

