/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.AbstractSurefireMojo;
import org.apache.maven.plugin.surefire.CommonReflector;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.BooterSerializer;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkNumberBucket;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.AbstractForkInputStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.NotifiableTestStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestLessInputStream;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestProvidingInputStream;
import org.apache.maven.plugin.surefire.booterclient.output.ForkClient;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.booterclient.output.NativeStdErrStreamConsumer;
import org.apache.maven.plugin.surefire.booterclient.output.ThreadedStreamConsumer;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.KeyValueSource;
import org.apache.maven.surefire.booter.PropertiesWrapper;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineCallable;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.ShutdownHookUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.internal.ConcurrencyUtils;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.util.internal.ObjectUtils;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkStarter {
    private static final String EXECUTION_EXCEPTION = "ExecutionException";
    private static final long PING_IN_SECONDS = 10L;
    private static final int TIMEOUT_CHECK_PERIOD_MILLIS = 100;
    private static final ThreadFactory FORKED_JVM_DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory((String)"surefire-fork-starter");
    private static final ThreadFactory SHUTDOWN_HOOK_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory((String)"surefire-jvm-killer-shutdownhook");
    private static final AtomicInteger SYSTEM_PROPERTIES_FILE_COUNTER = new AtomicInteger();
    private final ScheduledExecutorService pingThreadScheduler = ForkStarter.createPingScheduler();
    private final ScheduledExecutorService timeoutCheckScheduler;
    private final Queue<ForkClient> currentForkClients;
    private final int forkedProcessTimeoutInSeconds;
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private final ForkConfiguration forkConfiguration;
    private final StartupReportConfiguration startupReportConfiguration;
    private final ConsoleLogger log;
    private final DefaultReporterFactory defaultReporterFactory;
    private final Collection<DefaultReporterFactory> defaultReporterFactories;

    public ForkStarter(ProviderConfiguration providerConfiguration, StartupConfiguration startupConfiguration, ForkConfiguration forkConfiguration, int forkedProcessTimeoutInSeconds, StartupReportConfiguration startupReportConfiguration, ConsoleLogger log) {
        this.forkConfiguration = forkConfiguration;
        this.providerConfiguration = providerConfiguration;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
        this.log = log;
        this.defaultReporterFactory = new DefaultReporterFactory(startupReportConfiguration, log);
        this.defaultReporterFactory.runStarting();
        this.defaultReporterFactories = new ConcurrentLinkedQueue<DefaultReporterFactory>();
        this.currentForkClients = new ConcurrentLinkedQueue<ForkClient>();
        this.timeoutCheckScheduler = ForkStarter.createTimeoutCheckScheduler();
        this.triggerTimeoutCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult run(@Nonnull SurefireProperties effectiveSystemProperties, @Nonnull DefaultScanResult scanResult) throws SurefireBooterForkException, SurefireExecutionException {
        try {
            Map providerProperties = this.providerConfiguration.getProviderProperties();
            scanResult.writeTo(providerProperties);
            RunResult runResult = this.isForkOnce() ? this.run(effectiveSystemProperties, providerProperties) : this.run(effectiveSystemProperties);
            return runResult;
        }
        finally {
            this.defaultReporterFactory.mergeFromOtherFactories(this.defaultReporterFactories);
            this.defaultReporterFactory.close();
            this.pingThreadScheduler.shutdownNow();
            this.timeoutCheckScheduler.shutdownNow();
        }
    }

    public void killOrphanForks() {
        for (ForkClient fork : this.currentForkClients) {
            fork.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult run(SurefireProperties effectiveSystemProperties, Map<String, String> providerProperties) throws SurefireBooterForkException {
        TestLessInputStream.TestLessInputStreamBuilder builder = new TestLessInputStream.TestLessInputStreamBuilder();
        PropertiesWrapper props = new PropertiesWrapper(providerProperties);
        TestLessInputStream stream = builder.build();
        Thread shutdown = ForkStarter.createImmediateShutdownHookThread(builder, this.providerConfiguration.getShutdown());
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(builder);
        int forkNumber = ForkNumberBucket.drawNumber();
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            DefaultReporterFactory forkedReporterFactory = new DefaultReporterFactory(this.startupReportConfiguration, this.log, forkNumber);
            this.defaultReporterFactories.add(forkedReporterFactory);
            ForkClient forkClient = new ForkClient(forkedReporterFactory, stream, this.log, new AtomicBoolean(), forkNumber);
            RunResult runResult = this.fork(null, (KeyValueSource)props, forkClient, effectiveSystemProperties, forkNumber, stream, false);
            return runResult;
        }
        finally {
            ForkNumberBucket.returnNumber(forkNumber);
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            builder.removeStream(stream);
        }
    }

    private RunResult run(SurefireProperties effectiveSystemProperties) throws SurefireBooterForkException {
        return this.forkConfiguration.isReuseForks() ? this.runSuitesForkOnceMultiple(effectiveSystemProperties, this.forkConfiguration.getForkCount()) : this.runSuitesForkPerTestSet(effectiveSystemProperties, this.forkConfiguration.getForkCount());
    }

    private boolean isForkOnce() {
        return this.forkConfiguration.isReuseForks() && (this.forkConfiguration.getForkCount() == 1 || this.hasSuiteXmlFiles());
    }

    private boolean hasSuiteXmlFiles() {
        TestRequest testSuiteDefinition = this.providerConfiguration.getTestSuiteDefinition();
        return testSuiteDefinition != null && !testSuiteDefinition.getSuiteXmlFiles().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkOnceMultiple(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(forkCount));
        executorService.setThreadFactory(FORKED_JVM_DAEMON_THREAD_FACTORY);
        ConcurrentLinkedQueue<String> tests = new ConcurrentLinkedQueue<String>();
        for (Class<?> clazz : this.getSuitesIterator()) {
            tests.add(clazz.getName());
        }
        final ConcurrentLinkedQueue<TestProvidingInputStream> testStreams = new ConcurrentLinkedQueue<TestProvidingInputStream>();
        int total = StrictMath.min(forkCount, tests.size());
        for (int forkNum = 0; forkNum < total; ++forkNum) {
            testStreams.add(new TestProvidingInputStream(tests));
        }
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(testStreams);
        Thread shutdown = ForkStarter.createShutdownHookThread(testStreams, this.providerConfiguration.getShutdown());
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            int failFastCount = this.providerConfiguration.getSkipAfterFailureCount();
            final AtomicInteger notifyStreamsToSkipTestsJustNow = new AtomicInteger(failFastCount);
            ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(forkCount);
            final AtomicBoolean printedErrorStream = new AtomicBoolean();
            for (final TestProvidingInputStream testProvidingInputStream : testStreams) {
                Callable<RunResult> pf = new Callable<RunResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public RunResult call() throws Exception {
                        int forkNumber = ForkNumberBucket.drawNumber();
                        DefaultReporterFactory reporter = new DefaultReporterFactory(ForkStarter.this.startupReportConfiguration, ForkStarter.this.log, forkNumber);
                        ForkStarter.this.defaultReporterFactories.add(reporter);
                        ForkClient forkClient = new ForkClient(reporter, testProvidingInputStream, ForkStarter.this.log, printedErrorStream, forkNumber){

                            @Override
                            protected void stopOnNextTest() {
                                if (ConcurrencyUtils.countDownToZero((AtomicInteger)notifyStreamsToSkipTestsJustNow)) {
                                    ForkStarter.notifyStreamsToSkipTests(testStreams);
                                }
                            }
                        };
                        Map providerProperties = ForkStarter.this.providerConfiguration.getProviderProperties();
                        try {
                            RunResult runResult = ForkStarter.this.fork(null, (KeyValueSource)new PropertiesWrapper(providerProperties), forkClient, effectiveSystemProperties, forkNumber, testProvidingInputStream, true);
                            return runResult;
                        }
                        finally {
                            ForkNumberBucket.returnNumber(forkNumber);
                        }
                    }
                };
                results.add(executorService.submit(pf));
            }
            RunResult runResult = ForkStarter.awaitResultsDone(results, executorService);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            this.closeExecutor(executorService);
        }
    }

    private static void notifyStreamsToSkipTests(Collection<? extends NotifiableTestStream> notifiableTestStreams) {
        for (NotifiableTestStream notifiableTestStream : notifiableTestStreams) {
            notifiableTestStream.skipSinceNextTest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult runSuitesForkPerTestSet(final SurefireProperties effectiveSystemProperties, int forkCount) throws SurefireBooterForkException {
        ArrayList<Future<RunResult>> results = new ArrayList<Future<RunResult>>(500);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(forkCount, forkCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executorService.setThreadFactory(FORKED_JVM_DAEMON_THREAD_FACTORY);
        final TestLessInputStream.TestLessInputStreamBuilder builder = new TestLessInputStream.TestLessInputStreamBuilder();
        ScheduledFuture<?> ping = this.triggerPingTimerForShutdown(builder);
        Thread shutdown = ForkStarter.createCachableShutdownHookThread(builder, this.providerConfiguration.getShutdown());
        try {
            ShutdownHookUtils.addShutDownHook(shutdown);
            int failFastCount = this.providerConfiguration.getSkipAfterFailureCount();
            final AtomicInteger notifyStreamsToSkipTestsJustNow = new AtomicInteger(failFastCount);
            final AtomicBoolean printedErrorStream = new AtomicBoolean();
            for (final Class<?> testSet : this.getSuitesIterator()) {
                Callable<RunResult> pf = new Callable<RunResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public RunResult call() throws Exception {
                        int forkNumber = ForkNumberBucket.drawNumber();
                        DefaultReporterFactory forkedReporterFactory = new DefaultReporterFactory(ForkStarter.this.startupReportConfiguration, ForkStarter.this.log, forkNumber);
                        ForkStarter.this.defaultReporterFactories.add(forkedReporterFactory);
                        ForkClient forkClient = new ForkClient(forkedReporterFactory, builder.getImmediateCommands(), ForkStarter.this.log, printedErrorStream, forkNumber){

                            @Override
                            protected void stopOnNextTest() {
                                if (ConcurrencyUtils.countDownToZero((AtomicInteger)notifyStreamsToSkipTestsJustNow)) {
                                    builder.getCachableCommands().skipSinceNextTest();
                                }
                            }
                        };
                        TestLessInputStream stream = builder.build();
                        try {
                            RunResult runResult = ForkStarter.this.fork(testSet, (KeyValueSource)new PropertiesWrapper(ForkStarter.this.providerConfiguration.getProviderProperties()), forkClient, effectiveSystemProperties, forkNumber, stream, false);
                            return runResult;
                        }
                        finally {
                            ForkNumberBucket.returnNumber(forkNumber);
                            builder.removeStream(stream);
                        }
                    }
                };
                results.add(executorService.submit(pf));
            }
            RunResult runResult = ForkStarter.awaitResultsDone(results, executorService);
            return runResult;
        }
        finally {
            ShutdownHookUtils.removeShutdownHook(shutdown);
            ping.cancel(true);
            this.closeExecutor(executorService);
        }
    }

    private static RunResult awaitResultsDone(Collection<Future<RunResult>> results, ExecutorService executorService) throws SurefireBooterForkException {
        RunResult globalResult = new RunResult(0, 0, 0, 0);
        SurefireBooterForkException exception = null;
        for (Future<RunResult> result : results) {
            try {
                RunResult cur = result.get();
                if (cur != null) {
                    globalResult = globalResult.aggregate(cur);
                    continue;
                }
                throw new SurefireBooterForkException("No results for " + result.toString());
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
                throw new SurefireBooterForkException("Interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable realException = e.getCause();
                if (realException == null) {
                    if (exception != null) continue;
                    exception = new SurefireBooterForkException(EXECUTION_EXCEPTION);
                    continue;
                }
                String previousError = "";
                if (exception != null && !EXECUTION_EXCEPTION.equals(exception.getLocalizedMessage().trim())) {
                    previousError = exception.getLocalizedMessage() + "\n";
                }
                String error = previousError + EXECUTION_EXCEPTION + " " + realException.getLocalizedMessage();
                exception = new SurefireBooterForkException(error, realException);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return globalResult;
    }

    private void closeExecutor(ExecutorService executorService) throws SurefireBooterForkException {
        executorService.shutdown();
        try {
            executorService.awaitTermination(3600L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SurefireBooterForkException("Interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult fork(Object testSet, KeyValueSource providerProperties, ForkClient forkClient, SurefireProperties effectiveSystemProperties, int forkNumber, AbstractForkInputStream testProvidingInputStream, boolean readTestsFromInStream) throws SurefireBooterForkException {
        SurefireBooterForkException booterForkException;
        RunResult runResult;
        Integer result;
        CloseableCloser closer;
        OutputStreamFlushableCommandline cli;
        block29: {
            File systPropsFile;
            File surefireProperties;
            String tempDir;
            try {
                tempDir = this.forkConfiguration.getTempDirectory().getCanonicalPath();
                BooterSerializer booterSerializer = new BooterSerializer(this.forkConfiguration);
                Long pluginPid = this.forkConfiguration.getPluginPlatform().getPluginPid();
                surefireProperties = booterSerializer.serialize(providerProperties, this.providerConfiguration, this.startupConfiguration, testSet, readTestsFromInStream, pluginPid, forkNumber);
                this.log.debug("Determined Maven Process ID " + pluginPid);
                if (effectiveSystemProperties != null) {
                    SurefireProperties filteredProperties = AbstractSurefireMojo.createCopyAndReplaceForkNumPlaceholder(effectiveSystemProperties, forkNumber);
                    systPropsFile = SystemPropertyManager.writePropertiesFile((Properties)filteredProperties, (File)this.forkConfiguration.getTempDirectory(), (String)("surefire_" + SYSTEM_PROPERTIES_FILE_COUNTER.getAndIncrement()), (boolean)this.forkConfiguration.isDebug());
                } else {
                    systPropsFile = null;
                }
            }
            catch (IOException e) {
                throw new SurefireBooterForkException("Error creating properties files for forking", (Throwable)e);
            }
            cli = this.forkConfiguration.createCommandLine(this.startupConfiguration, forkNumber);
            if (testProvidingInputStream != null) {
                testProvidingInputStream.setFlushReceiverProvider(cli);
            }
            cli.createArg().setValue(tempDir);
            cli.createArg().setValue(SurefireHelper.DUMP_FILE_PREFIX + forkNumber);
            cli.createArg().setValue(surefireProperties.getName());
            if (systPropsFile != null) {
                cli.createArg().setValue(systPropsFile.getName());
            }
            ThreadedStreamConsumer threadedStreamConsumer = new ThreadedStreamConsumer(forkClient);
            closer = new CloseableCloser(forkNumber, threadedStreamConsumer, (Closeable)ObjectUtils.requireNonNull((Object)testProvidingInputStream, (String)"null param"));
            this.log.debug("Forking command line: " + cli);
            result = null;
            runResult = null;
            booterForkException = null;
            try {
                NativeStdErrStreamConsumer stdErrConsumer = new NativeStdErrStreamConsumer(forkClient.getDefaultReporterFactory());
                CommandLineCallable future = CommandLineUtils.executeCommandLineAsCallable(cli, testProvidingInputStream, threadedStreamConsumer, stdErrConsumer, 0, closer, StringUtils.ISO_8859_1);
                this.currentForkClients.add(forkClient);
                result = future.call();
                if (forkClient.hadTimeout()) {
                    runResult = RunResult.timeout((RunResult)forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult());
                    break block29;
                }
                if (result != null && result == 0) break block29;
                booterForkException = new SurefireBooterForkException("Error occurred in starting fork, check output in log");
            }
            catch (CommandLineException e) {
                try {
                    runResult = RunResult.failure((RunResult)forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult(), (Exception)e);
                    String cliErr = e.getLocalizedMessage();
                    Throwable cause = e.getCause();
                    booterForkException = new SurefireBooterForkException("Error while executing forked tests.", cliErr, cause, runResult);
                }
                catch (Throwable throwable) {
                    this.currentForkClients.remove(forkClient);
                    closer.close();
                    if (runResult == null) {
                        runResult = forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult();
                    }
                    forkClient.close(runResult.isTimeout());
                    if (!runResult.isTimeout()) {
                        String detail;
                        Throwable cause = booterForkException == null ? null : booterForkException.getCause();
                        String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
                        if (forkClient.isErrorInFork()) {
                            StackTraceWriter errorInFork = forkClient.getErrorInFork();
                            throw new SurefireBooterForkException("There was an error in the forked process" + detail + '\n' + errorInFork.getThrowable().getLocalizedMessage(), cause);
                        }
                        if (!forkClient.isSaidGoodBye()) {
                            String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                            String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                            for (String test : forkClient.testsInProgress()) {
                                testsInProgress = testsInProgress + "\n" + test;
                            }
                            throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause);
                        }
                    }
                    if (booterForkException != null) {
                        throw booterForkException;
                    }
                    throw throwable;
                }
                this.currentForkClients.remove(forkClient);
                closer.close();
                if (runResult == null) {
                    runResult = forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult();
                }
                forkClient.close(runResult.isTimeout());
                if (!runResult.isTimeout()) {
                    String detail;
                    Throwable cause = booterForkException == null ? null : booterForkException.getCause();
                    String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
                    if (forkClient.isErrorInFork()) {
                        StackTraceWriter errorInFork = forkClient.getErrorInFork();
                        throw new SurefireBooterForkException("There was an error in the forked process" + detail + '\n' + errorInFork.getThrowable().getLocalizedMessage(), cause);
                    }
                    if (!forkClient.isSaidGoodBye()) {
                        String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                        String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                        for (String test : forkClient.testsInProgress()) {
                            testsInProgress = testsInProgress + "\n" + test;
                        }
                        throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause);
                    }
                }
                if (booterForkException != null) {
                    throw booterForkException;
                }
            }
        }
        this.currentForkClients.remove(forkClient);
        closer.close();
        if (runResult == null) {
            runResult = forkClient.getDefaultReporterFactory().getGlobalRunStatistics().getRunResult();
        }
        forkClient.close(runResult.isTimeout());
        if (!runResult.isTimeout()) {
            String detail;
            Throwable cause = booterForkException == null ? null : booterForkException.getCause();
            String string = detail = booterForkException == null ? "" : "\n" + booterForkException.getMessage();
            if (forkClient.isErrorInFork()) {
                StackTraceWriter errorInFork = forkClient.getErrorInFork();
                throw new SurefireBooterForkException("There was an error in the forked process" + detail + '\n' + errorInFork.getThrowable().getLocalizedMessage(), cause);
            }
            if (!forkClient.isSaidGoodBye()) {
                String errorCode = result == null ? "" : "\nProcess Exit Code: " + result;
                String testsInProgress = forkClient.hasTestsInProgress() ? "\nCrashed tests:" : "";
                for (String test : forkClient.testsInProgress()) {
                    testsInProgress = testsInProgress + "\n" + test;
                }
                throw new SurefireBooterForkException("The forked VM terminated without properly saying goodbye. VM crash or System.exit called?\nCommand was " + cli.toString() + detail + errorCode + testsInProgress, cause);
            }
        }
        if (booterForkException != null) {
            throw booterForkException;
        }
        return runResult;
    }

    private Iterable<Class<?>> getSuitesIterator() throws SurefireBooterForkException {
        try {
            AbstractPathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
            ClassLoader unifiedClassLoader = classpathConfiguration.createMergedClassLoader();
            CommonReflector commonReflector = new CommonReflector(unifiedClassLoader);
            Object reporterFactory = commonReflector.createReportingReporterFactory(this.startupReportConfiguration, this.log);
            ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, unifiedClassLoader, reporterFactory);
            SurefireProvider surefireProvider = providerFactory.createProvider(false);
            return surefireProvider.getSuites();
        }
        catch (SurefireExecutionException e) {
            throw new SurefireBooterForkException("Unable to create classloader to find test suites", (Throwable)e);
        }
    }

    private static Thread createImmediateShutdownHookThread(final TestLessInputStream.TestLessInputStreamBuilder builder, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                builder.getImmediateCommands().shutdown(shutdownType);
            }
        });
    }

    private static Thread createCachableShutdownHookThread(final TestLessInputStream.TestLessInputStreamBuilder builder, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                builder.getCachableCommands().shutdown(shutdownType);
            }
        });
    }

    private static Thread createShutdownHookThread(final Iterable<TestProvidingInputStream> streams, final Shutdown shutdownType) {
        return SHUTDOWN_HOOK_THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                for (TestProvidingInputStream stream : streams) {
                    stream.shutdown(shutdownType);
                }
            }
        });
    }

    private static ScheduledExecutorService createPingScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"ping-timer-10s");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private static ScheduledExecutorService createTimeoutCheckScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"timeout-check-timer");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private ScheduledFuture<?> triggerPingTimerForShutdown(final TestLessInputStream.TestLessInputStreamBuilder builder) {
        return this.pingThreadScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                builder.getImmediateCommands().noop();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> triggerPingTimerForShutdown(final Iterable<TestProvidingInputStream> streams) {
        return this.pingThreadScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (TestProvidingInputStream stream : streams) {
                    stream.noop();
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    private ScheduledFuture<?> triggerTimeoutCheck() {
        return this.timeoutCheckScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long systemTime = System.currentTimeMillis();
                for (ForkClient forkClient : ForkStarter.this.currentForkClients) {
                    forkClient.tryToTimeout(systemTime, ForkStarter.this.forkedProcessTimeoutInSeconds);
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private final class CloseableCloser
    implements Runnable,
    Closeable {
        private final int jvmRun;
        private final Queue<Closeable> testProvidingInputStream;
        private final Thread inputStreamCloserHook;

        CloseableCloser(int jvmRun, Closeable ... testProvidingInputStream) {
            this.jvmRun = jvmRun;
            this.testProvidingInputStream = new ConcurrentLinkedQueue<Closeable>();
            Collections.addAll(this.testProvidingInputStream, testProvidingInputStream);
            if (this.testProvidingInputStream.isEmpty()) {
                this.inputStreamCloserHook = null;
            } else {
                this.inputStreamCloserHook = DaemonThreadFactory.newDaemonThread((Runnable)this, (String)"closer-shutdown-hook");
                ShutdownHookUtils.addShutDownHook(this.inputStreamCloserHook);
            }
        }

        @Override
        public void run() {
            Closeable closeable;
            while ((closeable = this.testProvidingInputStream.poll()) != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    String msg = "ForkStarter IOException: " + e.getLocalizedMessage() + ".";
                    File reportsDir = ForkStarter.this.defaultReporterFactory.getReportsDirectory();
                    File dump = InPluginProcessDumpSingleton.getSingleton().dumpStreamException(e, msg, reportsDir, this.jvmRun);
                    ForkStarter.this.log.warning(msg + " See the dump file " + dump.getAbsolutePath());
                }
            }
        }

        @Override
        public void close() {
            this.run();
            if (this.inputStreamCloserHook != null) {
                ShutdownHookUtils.removeShutdownHook(this.inputStreamCloserHook);
            }
        }
    }
}

