/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser.extensions;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.extensions.MinSE;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.ParametersParser;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;

public class MinSEParser
extends ParametersParser {
    public MinSEParser(String text) {
        super(text);
    }

    protected MinSEParser(Lexer lexer) {
        super(lexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIPHeader parse() throws ParseException {
        MinSE minse = new MinSE();
        if (debug) {
            this.dbg_enter("parse");
        }
        try {
            this.headerName(2134);
            String nextId = this.lexer.getNextId();
            try {
                int delta = Integer.parseInt(nextId);
                minse.setExpires(delta);
            }
            catch (NumberFormatException ex) {
                throw this.createParseException("bad integer format");
            }
            catch (InvalidArgumentException ex) {
                throw this.createParseException(ex.getMessage());
            }
            this.lexer.SPorHT();
            super.parse(minse);
            MinSE minSE = minse;
            return minSE;
        }
        finally {
            if (debug) {
                this.dbg_leave("parse");
            }
        }
    }

    public static void main(String[] args) throws ParseException {
        String[] to = new String[]{"Min-SE: 30\n", "Min-SE: 45;some-param=somevalue\n"};
        for (int i = 0; i < to.length; ++i) {
            MinSEParser tp = new MinSEParser(to[i]);
            MinSE t = (MinSE)tp.parse();
            System.out.println("encoded = " + t.encode());
            System.out.println("\ntime=" + t.getExpires());
            if (t.getParameter("some-param") == null) continue;
            System.out.println("some-param=" + t.getParameter("some-param"));
        }
    }
}

