/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.CharsetKt;
import io.ktor.util.CryptoKt;
import io.ktor.util.Digest;
import io.ktor.util.InternalAPI;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=5, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b\u001a\u001d\u0010\u000b\u001a\u00020\u0005*\u00020\f2\u0006\u0010\t\u001a\u00020\u0005H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a+\u0010\u000b\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\f\b\u0002\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"NONCE_SIZE_IN_BYTES", "", "digits", "", "generateNonce", "", "size", "hex", "", "bytes", "s", "build", "Lio/ktor/util/Digest;", "(Lio/ktor/util/Digest;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "string", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "(Lio/ktor/util/Digest;Ljava/lang/String;Ljava/nio/charset/Charset;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-utils"}, xs="io/ktor/util/CryptoKt")
final class CryptoKt__CryptoKt {
    @NotNull
    private static final char[] digits = CharsetKt.toCharArray("0123456789abcdef");

    @NotNull
    public static final String hex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        char[] result = new char[bytes.length * 2];
        int resultIndex = 0;
        char[] digits = CryptoKt__CryptoKt.digits;
        int n = bytes.length;
        for (int index = 0; index < n; ++index) {
            int b = bytes[index] & 0xFF;
            result[resultIndex++] = digits[b >> 4];
            result[resultIndex++] = digits[b & 0xF];
        }
        return kotlin.text.StringsKt.concatToString((char[])result);
    }

    @NotNull
    public static final byte[] hex(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] result = new byte[s.length() / 2];
        int n = result.length;
        for (int idx = 0; idx < n; ++idx) {
            int srcIdx = idx * 2;
            int high = Integer.parseInt(String.valueOf(s.charAt(srcIdx)), CharsKt.checkRadix((int)16)) << 4;
            int low = Integer.parseInt(String.valueOf(s.charAt(srcIdx + 1)), CharsKt.checkRadix((int)16));
            result[idx] = (byte)(high | low);
        }
        return result;
    }

    @NotNull
    public static final byte[] generateNonce(int size) {
        ByteReadPacket byteReadPacket;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$generateNonce_u24lambda_u2d0 = builder$iv;
            boolean bl = false;
            while ($this$generateNonce_u24lambda_u2d0.getSize() < size) {
                StringsKt.writeText$default((Output)((Output)$this$generateNonce_u24lambda_u2d0), (CharSequence)CryptoKt.generateNonce(), (int)0, (int)0, null, (int)14, null);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        return StringsKt.readBytes((ByteReadPacket)byteReadPacket, (int)size);
    }

    @InternalAPI
    @Nullable
    public static final Object build(@NotNull Digest $this$build, @NotNull byte[] bytes, @NotNull Continuation<? super byte[]> $completion) {
        $this$build.plusAssign(bytes);
        return $this$build.build($completion);
    }

    @InternalAPI
    @Nullable
    public static final Object build(@NotNull Digest $this$build, @NotNull String string, @NotNull Charset charset, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray;
        String $this$toByteArray$iv = string;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset, (Object)Charsets.UTF_8)) {
            byArray = kotlin.text.StringsKt.encodeToByteArray((String)$this$toByteArray$iv);
        } else {
            CharsetEncoder charsetEncoder = charset.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray$iv, (int)0, (int)$this$toByteArray$iv.length());
        }
        $this$build.plusAssign(byArray);
        return $this$build.build($completion);
    }

    public static /* synthetic */ Object build$default(Digest digest, String string, Charset charset, Continuation continuation2, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return CryptoKt.build(digest, string, charset, (Continuation<? super byte[]>)continuation2);
    }
}

