/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.IVFHeader;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ivffile.VP8Frame;

public class IVFFileReader {
    private static int IVF_HEADER_LENGTH = 32;
    private IVFHeader header;
    private RandomAccessFile stream;

    public IVFFileReader(String filePath) {
        this.header = new IVFHeader(filePath);
        try {
            this.stream = new RandomAccessFile(filePath, "r");
            this.stream.seek(IVF_HEADER_LENGTH);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IVFHeader getHeader() {
        return this.header;
    }

    public VP8Frame getNextFrame(boolean loopFile) throws IOException {
        VP8Frame frame = new VP8Frame();
        this.getNextFrame(frame, loopFile);
        return frame;
    }

    public void getNextFrame(VP8Frame frame, boolean loopFile) throws IOException {
        if (loopFile && this.stream.getFilePointer() >= this.stream.length()) {
            this.stream.seek(this.header.getHeaderLength());
        }
        int frameSizeInBytes = IVFFileReader.changeEndianness(this.stream.readInt());
        long timestamp = IVFFileReader.changeEndianness(this.stream.readLong());
        byte[] data = new byte[frameSizeInBytes];
        this.stream.read(data);
        frame.set(timestamp, frameSizeInBytes, data);
    }

    public static int changeEndianness(int value) {
        return value << 24 & 0xFF000000 | value << 8 & 0xFF0000 | value >> 8 & 0xFF00 | value >> 24 & 0xFF;
    }

    public static short changeEndianness(short value) {
        return (short)(value << 8 & 0xFF00 | value >> 8 & 0xFF);
    }

    public static long changeEndianness(long value) {
        long b1 = value >> 0 & 0xFFL;
        long b2 = value >> 8 & 0xFFL;
        long b3 = value >> 16 & 0xFFL;
        long b4 = value >> 24 & 0xFFL;
        long b5 = value >> 32 & 0xFFL;
        long b6 = value >> 40 & 0xFFL;
        long b7 = value >> 48 & 0xFFL;
        long b8 = value >> 56 & 0xFFL;
        return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 << 0;
    }
}

