/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationFormField;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;

public class ChatRoomConfigurationFormFieldJabberImpl
implements ChatRoomConfigurationFormField {
    private final FormField smackFormField;
    private final FormField smackSubmitFormField;

    public ChatRoomConfigurationFormFieldJabberImpl(FormField formField, Form submitForm) {
        this.smackFormField = formField;
        this.smackSubmitFormField = !formField.getType().equals((Object)FormField.Type.fixed) ? submitForm.getField(formField.getVariable()) : null;
    }

    public String getName() {
        return this.smackFormField.getVariable();
    }

    public String getDescription() {
        return this.smackFormField.getDescription();
    }

    public String getLabel() {
        return this.smackFormField.getLabel();
    }

    public Iterator<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (FormField.Option smackOption : this.smackFormField.getOptions()) {
            options.add(smackOption.getValue());
        }
        return Collections.unmodifiableList(options).iterator();
    }

    public boolean isRequired() {
        return this.smackFormField.isRequired();
    }

    public String getType() {
        FormField.Type smackType = this.smackFormField.getType();
        if (smackType.equals((Object)FormField.Type.bool)) {
            return "Boolean";
        }
        if (smackType.equals((Object)FormField.Type.fixed)) {
            return "FixedText";
        }
        if (smackType.equals((Object)FormField.Type.text_private)) {
            return "PrivateText";
        }
        if (smackType.equals((Object)FormField.Type.text_single)) {
            return "SingleLineText";
        }
        if (smackType.equals((Object)FormField.Type.text_multi)) {
            return "MultipleLinesText";
        }
        if (smackType.equals((Object)FormField.Type.list_single)) {
            return "ListSingleChoice";
        }
        if (smackType.equals((Object)FormField.Type.list_multi)) {
            return "ListMultiChoice";
        }
        if (smackType.equals((Object)FormField.Type.jid_single)) {
            return "SingleIDChoice";
        }
        if (smackType.equals((Object)FormField.Type.jid_multi)) {
            return "MultiIDChoice";
        }
        return "Undefined";
    }

    public Iterator<?> getValues() {
        Iterator valuesIter;
        if (this.smackFormField.getType().equals((Object)FormField.Type.bool)) {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            for (String smackValue : this.smackFormField.getValues()) {
                values.add(smackValue.equals("1") || smackValue.equals("true") ? Boolean.TRUE : Boolean.FALSE);
            }
            valuesIter = values.iterator();
        } else {
            valuesIter = this.smackFormField.getValues().iterator();
        }
        return valuesIter;
    }

    public void addValue(Object value) {
        if (value instanceof Boolean) {
            value = (Boolean)value != false ? "1" : "0";
        }
        this.smackSubmitFormField.addValue(value.toString());
    }

    public void setValues(Object[] newValues) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object value : newValues) {
            String stringValue = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : (value == null ? null : value.toString());
            list.add(stringValue);
        }
        this.smackSubmitFormField.addValues(list);
    }
}

