/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil.wizard;

import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.plugin.desktoputil.MoveableTableModel;

public class EncryptionConfigurationTableModel
extends MoveableTableModel {
    private static final long serialVersionUID = 0L;
    private String[] encryptionProtocols;
    private boolean[] encryptionProtocolStatus;

    public EncryptionConfigurationTableModel(String[] encryptionProtocols, boolean[] encryptionProtocolStatus) {
        this.init(encryptionProtocols, encryptionProtocolStatus);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : super.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.encryptionProtocols.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.encryptionProtocolStatus[rowIndex];
            }
            case 1: {
                return this.encryptionProtocols[rowIndex];
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && value instanceof Boolean) {
            this.encryptionProtocolStatus[rowIndex] = (Boolean)value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public int move(int rowIndex, boolean up) {
        int toRowIndex;
        if (up ? (toRowIndex = rowIndex - 1) < 0 : (toRowIndex = rowIndex + 1) >= this.getRowCount()) {
            throw new IllegalArgumentException("rowIndex");
        }
        boolean tmpSelectionItem = this.encryptionProtocolStatus[rowIndex];
        this.encryptionProtocolStatus[rowIndex] = this.encryptionProtocolStatus[toRowIndex];
        this.encryptionProtocolStatus[toRowIndex] = tmpSelectionItem;
        String tmpLabel = this.encryptionProtocols[rowIndex];
        this.encryptionProtocols[rowIndex] = this.encryptionProtocols[toRowIndex];
        this.encryptionProtocols[toRowIndex] = tmpLabel;
        this.fireTableRowsUpdated(rowIndex, toRowIndex);
        return toRowIndex;
    }

    public Map<String, Integer> getEncryptionProtocols() {
        HashMap<String, Integer> encryptionProtocolMap = new HashMap<String, Integer>(this.encryptionProtocols.length);
        for (int i = 0; i < this.encryptionProtocols.length; ++i) {
            encryptionProtocolMap.put(this.encryptionProtocols[i], new Integer(i));
        }
        return encryptionProtocolMap;
    }

    public Map<String, Boolean> getEncryptionProtocolStatus() {
        HashMap<String, Boolean> encryptionProtocolStatusMap = new HashMap<String, Boolean>(this.encryptionProtocolStatus.length);
        for (int i = 0; i < this.encryptionProtocolStatus.length; ++i) {
            encryptionProtocolStatusMap.put(this.encryptionProtocols[i], new Boolean(this.encryptionProtocolStatus[i]));
        }
        return encryptionProtocolStatusMap;
    }

    public boolean isEnabledLabel(String label) {
        for (int i = 0; i < this.encryptionProtocols.length; ++i) {
            if (!this.encryptionProtocols[i].equals(label)) continue;
            return this.encryptionProtocolStatus[i];
        }
        return false;
    }

    public void init(String[] encryptionProtocols, boolean[] encryptionProtocolStatus) {
        this.encryptionProtocols = encryptionProtocols;
        this.encryptionProtocolStatus = encryptionProtocolStatus;
    }
}

