/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;

public class ImageCanvas
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private ImageIcon icon;

    public ImageCanvas(Image image) {
        this.setImage(image);
    }

    protected void paintComponent(Graphics g) {
        int height;
        super.paintComponent(g);
        if (this.icon == null) {
            return;
        }
        int imageWidth = this.icon.getIconWidth();
        if (imageWidth < 1) {
            return;
        }
        int imageHeight = this.icon.getIconHeight();
        if (imageHeight < 1) {
            return;
        }
        int width = this.getWidth();
        boolean scale = false;
        float scaleFactor = 1.0f;
        if (imageWidth > width) {
            scale = true;
            scaleFactor = (float)width / (float)imageWidth;
        }
        if (imageHeight > (height = this.getHeight())) {
            scale = true;
            scaleFactor = Math.min(scaleFactor, (float)height / (float)imageHeight);
        }
        if (scale) {
            imageWidth = Math.round((float)imageWidth * scaleFactor);
            imageHeight = Math.round((float)imageHeight * scaleFactor);
        }
        g.drawImage(this.icon.getImage(), (width - imageWidth) / 2, (height - imageHeight) / 2, imageWidth, imageHeight, null);
    }

    public void setImage(Image image) {
        ImageIcon imageIcon = this.icon = image == null ? null : new ImageIcon(image);
        if (this.icon != null) {
            int preferredWidth = this.icon.getIconWidth();
            int preferredHeight = this.icon.getIconHeight();
            this.setMinimumSize(new Dimension(preferredWidth, preferredHeight));
            this.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        }
    }
}

