/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class FadeInBalloonPanel
extends TransparentPanel {
    private Point beginPoint;
    private static final int beginPointShift = 6;

    public void setBeginPoint(Point beginPoint) {
        this.beginPoint = beginPoint;
    }

    protected void paintComponent(Graphics g) {
        g = g.create();
        try {
            this.internalPaintComponent((Graphics2D)g);
        }
        finally {
            g.dispose();
        }
    }

    private void internalPaintComponent(Graphics2D g) {
        float visibility;
        AntialiasingManager.activateAntialiasing(g);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = this.isVisible() ? 0.8f : 0.0f;
        if (fadeTracker.isTracked((Component)((Object)this), FadeKind.ROLLOVER)) {
            visibility = fadeTracker.getFade((Component)((Object)this), FadeKind.ROLLOVER);
        }
        g.setColor(new Color(0.0f, 0.0f, 0.0f, visibility));
        int y = 0;
        if (this.beginPoint != null) {
            y = 6;
            int[] x1Points = new int[]{this.beginPoint.x, this.beginPoint.x + 6, this.beginPoint.x - 6};
            int[] y1Points = new int[]{this.beginPoint.y, this.beginPoint.y + 6, this.beginPoint.y + 6};
            GeneralPath polygon = new GeneralPath(0, x1Points.length);
            polygon.moveTo(x1Points[0], y1Points[0]);
            for (int index = 1; index < x1Points.length; ++index) {
                polygon.lineTo(x1Points[index], y1Points[index]);
            }
            polygon.closePath();
            g.fill(polygon);
        }
        if (visibility != 0.0f) {
            g.fillRoundRect(0, y, this.getWidth(), this.getHeight(), 10, 10);
        }
    }

    public void setVisible(boolean isVisible) {
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (isVisible) {
            fadeTracker.trackFadeIn(FadeKind.ROLLOVER, (Component)((Object)this), true, (FadeTrackerCallback)new PanelRepaintCallback());
        } else {
            fadeTracker.trackFadeOut(FadeKind.ROLLOVER, (Component)((Object)this), true, (FadeTrackerCallback)new PanelRepaintCallback());
        }
    }

    private class PanelRepaintCallback
    implements FadeTrackerCallback {
        private PanelRepaintCallback() {
        }

        public void fadeEnded(FadeKind arg0) {
            this.repaintLater();
        }

        public void fadePerformed(FadeKind arg0, float arg1) {
            this.repaintLater();
        }

        private void repaintLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FadeInBalloonPanel.this.repaint();
                }
            });
        }

        public void fadeReversed(FadeKind arg0, boolean arg1, float arg2) {
        }
    }
}

