/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.eventadmin.Event;
import org.jitsi.osgi.EventHandlerActivator;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointMessageBuilder;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.Videobridge;
import org.osgi.framework.BundleContext;

public class EndpointConnectionStatus
extends EventHandlerActivator {
    private static final String CFG_PNAME_BASE = "org.jitsi.videobridge.EndpointConnectionStatus";
    public static final String CFG_PNAME_FIRST_TRANSFER_TIMEOUT = "org.jitsi.videobridge.EndpointConnectionStatus.FIRST_TRANSFER_TIMEOUT";
    public static final String CFG_PNAME_MAX_INACTIVITY_LIMIT = "org.jitsi.videobridge.EndpointConnectionStatus.MAX_INACTIVITY_LIMIT";
    private static final long DEFAULT_FIRST_TRANSFER_TIMEOUT = 15000L;
    private static final long DEFAULT_MAX_INACTIVITY_LIMIT = 3000L;
    private static final Logger logger = Logger.getLogger(EndpointConnectionStatus.class);
    private long firstTransferTimeout;
    private long maxInactivityLimit;
    private static final long PROBE_INTERVAL = 500L;
    private BundleContext bundleContext;
    private List<Endpoint> inactiveEndpoints = new LinkedList<Endpoint>();
    private Timer timer;

    public EndpointConnectionStatus() {
        super(new String[]{"org/jitsi/videobridge/Endpoint/MSG_TRANSPORT_READY_TOPIC"});
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        if (this.timer == null) {
            this.timer = new Timer("EndpointConnectionStatusMonitoring", true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EndpointConnectionStatus.this.doMonitor();
                }
            }, 500L, 500L);
        } else {
            logger.error((Object)"Endpoint connection monitoring is already running");
        }
        ConfigurationService config = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        this.firstTransferTimeout = config.getLong(CFG_PNAME_FIRST_TRANSFER_TIMEOUT, 15000L);
        this.maxInactivityLimit = config.getLong(CFG_PNAME_MAX_INACTIVITY_LIMIT, 3000L);
        if (this.firstTransferTimeout <= this.maxInactivityLimit) {
            throw new IllegalArgumentException(String.format("FIRST_TRANSFER_TIMEOUT(%s) must be greater than MAX_INACTIVITY_LIMIT(%s)", this.firstTransferTimeout, this.maxInactivityLimit));
        }
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.inactiveEndpoints.clear();
        this.bundleContext = null;
    }

    private void doMonitor() {
        BundleContext bundleContext = this.bundleContext;
        if (bundleContext != null) {
            Collection<Videobridge> jvbs = Videobridge.getVideobridges(bundleContext);
            for (Videobridge videobridge : jvbs) {
                this.cleanupExpiredEndpointsStatus();
                Conference[] conferences = videobridge.getConferences();
                Arrays.stream(conferences).forEachOrdered(conference -> conference.getEndpoints().forEach(this::monitorEndpointActivity));
            }
        }
    }

    private void monitorEndpointActivity(AbstractEndpoint abstractEndpoint) {
        long noActivityForMs;
        boolean inactive;
        if (!(abstractEndpoint instanceof Endpoint)) {
            return;
        }
        Endpoint endpoint = (Endpoint)abstractEndpoint;
        String endpointId = endpoint.getID();
        List<RtpChannel> rtpChannels = endpoint.getChannels();
        long lastActivity = rtpChannels.stream().mapToLong(Channel::getLastTransportActivityTime).max().orElse(0L);
        long mostRecentChannelCreated = rtpChannels.stream().mapToLong(Channel::getCreationTimestamp).max().orElse(0L);
        SctpConnection sctpConnection = endpoint.getSctpConnection();
        if (sctpConnection != null) {
            long creationTimestamp;
            long lastSctpActivity = sctpConnection.getLastTransportActivityTime();
            if (lastSctpActivity > lastActivity) {
                lastActivity = lastSctpActivity;
            }
            if ((creationTimestamp = sctpConnection.getCreationTimestamp()) > mostRecentChannelCreated) {
                mostRecentChannelCreated = creationTimestamp;
            }
        }
        if (lastActivity == 0L) {
            if (System.currentTimeMillis() - mostRecentChannelCreated > this.firstTransferTimeout) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(endpointId + " is having trouble establishing the connection and will be marked as inactive"));
                }
                lastActivity = mostRecentChannelCreated;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(endpointId + " not ready for activity checks yet"));
                }
                return;
            }
        }
        boolean bl = inactive = (noActivityForMs = System.currentTimeMillis() - lastActivity) > this.maxInactivityLimit;
        if (inactive && !this.inactiveEndpoints.contains((Object)endpoint)) {
            logger.debug((Object)(endpointId + " is considered disconnected"));
            this.inactiveEndpoints.add(endpoint);
            this.sendEndpointConnectionStatus(endpoint, false, null);
        } else if (!inactive && this.inactiveEndpoints.contains((Object)endpoint)) {
            logger.debug((Object)(endpointId + " has reconnected"));
            this.inactiveEndpoints.remove((Object)endpoint);
            this.sendEndpointConnectionStatus(endpoint, true, null);
        }
        if (inactive && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("No activity on %s for %s", endpointId, (double)noActivityForMs / 1000.0));
        }
    }

    private void sendEndpointConnectionStatus(Endpoint subjectEndpoint, boolean isConnected, Endpoint msgReceiver) {
        Conference conference = subjectEndpoint.getConference();
        if (conference != null) {
            String msg = EndpointMessageBuilder.createEndpointConnectivityStatusChangeEvent(subjectEndpoint.getID(), isConnected);
            if (msgReceiver == null) {
                conference.broadcastMessage(msg, true);
            } else {
                List<AbstractEndpoint> receivers = Collections.singletonList(msgReceiver);
                conference.sendMessage(msg, receivers);
            }
        } else {
            logger.warn((Object)("Attempt to send connectivity status update for endpoint " + subjectEndpoint.getID() + " without parent conference instance (expired?)"));
        }
    }

    private void cleanupExpiredEndpointsStatus() {
        this.inactiveEndpoints.removeIf(e -> {
            boolean endpointReplaced;
            Conference conference = e.getConference();
            AbstractEndpoint replacement = conference.getEndpoint(e.getID());
            boolean bl = endpointReplaced = replacement != null && replacement != e;
            if (endpointReplaced && replacement instanceof Endpoint) {
                this.sendEndpointConnectionStatus((Endpoint)replacement, true, null);
            }
            return conference.isExpired() || endpointReplaced;
        });
        if (logger.isDebugEnabled()) {
            this.inactiveEndpoints.stream().filter(AbstractEndpoint::isExpired).forEach(e -> logger.debug((Object)("Endpoint has expired: " + e.getID() + ", but is still on the list")));
        }
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if (!"org/jitsi/videobridge/Endpoint/MSG_TRANSPORT_READY_TOPIC".equals(topic)) {
            logger.warn((Object)("Received event for unexpected topic: " + topic));
            return;
        }
        Endpoint endpoint = (Endpoint)((Object)event.getProperty((Object)"event.source"));
        if (endpoint == null) {
            logger.error((Object)"Endpoint is null");
            return;
        }
        Conference conference = endpoint.getConference();
        if (conference == null || conference.isExpired()) {
            return;
        }
        this.inactiveEndpoints.stream().filter(e -> e.getConference() == conference).forEach(e -> this.sendEndpointConnectionStatus((Endpoint)((Object)e), false, endpoint));
    }
}

