/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.ExportedObject;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.RemoteObject;
import org.freedesktop.dbus.SignalTuple;
import org.freedesktop.dbus.Transport;
import org.freedesktop.dbus.exceptions.DBusException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectConnection
extends AbstractConnection {
    public DirectConnection(String string) throws DBusException {
        super(string);
        try {
            this.transport = new Transport(this.addr, 100000);
            this.connected = true;
        }
        catch (IOException iOException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(Gettext._("Failed to connect to bus ") + iOException.getMessage());
        }
        catch (ParseException parseException) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(Gettext._("Failed to connect to bus ") + parseException.getMessage());
        }
        this.listen();
    }

    public static String createDynamicTCPSession() {
        int n;
        String string = "tcp:host=localhost";
        try {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.bind(null);
            n = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (Exception exception) {
            Random random = new Random();
            n = 32768 + Math.abs(random.nextInt()) % 28232;
        }
        string = string + ",port=" + n;
        string = string + ",guid=" + Transport.genGUID();
        return string;
    }

    public static String createDynamicSession() {
        StringBuffer stringBuffer;
        String string = "unix:";
        String string2 = "/tmp/dbus-XXXXXXXXXX";
        Random random = new Random();
        do {
            stringBuffer = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                stringBuffer.append((char)(Math.abs(random.nextInt()) % 26 + 65));
            }
        } while (new File(string2 = string2.replaceAll("..........$", stringBuffer.toString())).exists());
        string = string + "abstract=" + string2;
        string = string + ",guid=" + Transport.genGUID();
        return string;
    }

    DBusInterface dynamicProxy(String string) throws DBusException {
        try {
            DBus.Introspectable introspectable = (DBus.Introspectable)this.getRemoteObject(string, DBus.Introspectable.class);
            String string2 = introspectable.Introspect();
            String[] stringArray = string2.split("[<>]");
            Vector<String> vector = new Vector<String>();
            for (String string3 : stringArray) {
                if (!string3.startsWith("interface")) continue;
                vector.add(string3.replaceAll("^interface *name *= *['\"]([^'\"]*)['\"].*$", "$1"));
            }
            Vector vector2 = new Vector();
            block5: for (String string4 : vector) {
                int n = 0;
                while (n >= 0) {
                    try {
                        vector2.add(Class.forName(string4));
                        continue block5;
                    }
                    catch (Exception exception) {
                        n = string4.lastIndexOf(".");
                        char[] cArray = string4.toCharArray();
                        if (n < 0) continue;
                        cArray[n] = 36;
                        string4 = String.valueOf(cArray);
                    }
                }
            }
            if (vector2.size() == 0) {
                throw new DBusException(Gettext._("Could not find an interface to cast to"));
            }
            RemoteObject remoteObject = new RemoteObject(null, string, null, false);
            DBusInterface dBusInterface = (DBusInterface)Proxy.newProxyInstance(((Class)vector2.get(0)).getClassLoader(), vector2.toArray(new Class[0]), (InvocationHandler)new RemoteInvocationHandler(this, remoteObject));
            this.importedObjects.put(dBusInterface, remoteObject);
            return dBusInterface;
        }
        catch (Exception exception) {
            if (EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new DBusException(MessageFormat.format(Gettext._("Failed to create proxy object for {0}; reason: {1}."), string, exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBusInterface getExportedObject(String string) throws DBusException {
        ExportedObject exportedObject = null;
        Map map = this.exportedObjects;
        synchronized (map) {
            exportedObject = (ExportedObject)this.exportedObjects.get(string);
        }
        if (null != exportedObject && null == exportedObject.object.get()) {
            this.unExportObject(string);
            exportedObject = null;
        }
        if (null != exportedObject) {
            return exportedObject.object.get();
        }
        return this.dynamicProxy(string);
    }

    public DBusInterface getRemoteObject(String string) throws DBusException {
        if (null == string) {
            throw new DBusException(Gettext._("Invalid object path: null"));
        }
        if (!string.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        return this.dynamicProxy(string);
    }

    public DBusInterface getRemoteObject(String string, Class<? extends DBusInterface> clazz) throws DBusException {
        if (null == string) {
            throw new DBusException(Gettext._("Invalid object path: null"));
        }
        if (null == clazz) {
            throw new ClassCastException(Gettext._("Not A DBus Interface"));
        }
        if (!string.matches("^/([-_a-zA-Z0-9]+(/[-_a-zA-Z0-9]+)*)?$") || string.length() > 255) {
            throw new DBusException(Gettext._("Invalid object path: ") + string);
        }
        if (!DBusInterface.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(Gettext._("Not A DBus Interface"));
        }
        if (clazz.getName().equals(clazz.getSimpleName())) {
            throw new DBusException(Gettext._("DBusInterfaces cannot be declared outside a package"));
        }
        RemoteObject remoteObject = new RemoteObject(null, string, clazz, false);
        DBusInterface dBusInterface = (DBusInterface)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new RemoteInvocationHandler(this, remoteObject));
        this.importedObjects.put(dBusInterface, remoteObject);
        return dBusInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void removeSigHandler(DBusMatchRule dBusMatchRule, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        SignalTuple signalTuple = new SignalTuple(dBusMatchRule.getInterface(), dBusMatchRule.getMember(), dBusMatchRule.getObject(), dBusMatchRule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector vector = (Vector)this.handledSignals.get(signalTuple);
            if (null != vector) {
                vector.remove(dBusSigHandler);
                if (0 == vector.size()) {
                    this.handledSignals.remove(signalTuple);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends DBusSignal> void addSigHandler(DBusMatchRule dBusMatchRule, DBusSigHandler<T> dBusSigHandler) throws DBusException {
        SignalTuple signalTuple = new SignalTuple(dBusMatchRule.getInterface(), dBusMatchRule.getMember(), dBusMatchRule.getObject(), dBusMatchRule.getSource());
        Map map = this.handledSignals;
        synchronized (map) {
            Vector<DBusSigHandler<T>> vector = (Vector<DBusSigHandler<T>>)this.handledSignals.get(signalTuple);
            if (null == vector) {
                vector = new Vector<DBusSigHandler<T>>();
                vector.add(dBusSigHandler);
                this.handledSignals.put(signalTuple, vector);
            } else {
                vector.add(dBusSigHandler);
            }
        }
    }

    @Override
    DBusInterface getExportedObject(String string, String string2) throws DBusException {
        return this.getExportedObject(string2);
    }
}

