/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSetJitsiMeetTools;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;

public class OperationSetJitsiMeetToolsSipImpl
implements OperationSetJitsiMeetTools {
    public String JITSI_MEET_ROOM_HEADER = "Jitsi-Conference-Room";
    private static final String JITSI_MEET_ROOM_HEADER_PROPERTY = "JITSI_MEET_ROOM_HEADER_NAME";
    private static final Logger logger = Logger.getLogger(OperationSetJitsiMeetToolsSipImpl.class);
    private final List<OperationSetJitsiMeetTools.JitsiMeetRequestListener> requestHandlers = new CopyOnWriteArrayList<OperationSetJitsiMeetTools.JitsiMeetRequestListener>();

    public OperationSetJitsiMeetToolsSipImpl(ProtocolProviderServiceSipImpl parentProvider) {
        AccountID account = parentProvider.getAccountID();
        this.JITSI_MEET_ROOM_HEADER = account.getAccountPropertyString((Object)JITSI_MEET_ROOM_HEADER_PROPERTY, this.JITSI_MEET_ROOM_HEADER);
    }

    public void addRequestListener(OperationSetJitsiMeetTools.JitsiMeetRequestListener requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestListener(OperationSetJitsiMeetTools.JitsiMeetRequestListener requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    public void notifyJoinJitsiMeetRoom(Call call, Map<String, String> callHeaders) {
        String jitsiMeetRoom = callHeaders.get(this.JITSI_MEET_ROOM_HEADER);
        if (jitsiMeetRoom == null) {
            return;
        }
        boolean handled = false;
        for (OperationSetJitsiMeetTools.JitsiMeetRequestListener l : this.requestHandlers) {
            l.onJoinJitsiMeetRequest(call, jitsiMeetRoom, callHeaders);
            handled = true;
        }
        if (!handled) {
            logger.warn((Object)("Unhandled join Jitsi Meet request R:" + jitsiMeetRoom + " C: " + call));
        }
    }

    public void addSupportedFeature(String featureName) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void removeSupportedFeature(String featureName) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void sendPresenceExtension(ChatRoom chatRoom, ExtensionElement extension) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void removePresenceExtension(ChatRoom chatRoom, ExtensionElement extension) {
        throw new RuntimeException("Not implemented for SIP");
    }

    public void setPresenceStatus(ChatRoom chatRoom, String statusMessage) {
        throw new RuntimeException("Not implemented for SIP");
    }
}

