/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.internal.DnsNameResolver;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

final class JndiResourceResolverFactory
implements DnsNameResolver.ResourceResolverFactory {
    @Nullable
    private static final Throwable JNDI_UNAVAILABILITY_CAUSE = JndiResourceResolverFactory.initJndi();

    @Nullable
    private static Throwable initJndi() {
        if (GrpcUtil.IS_RESTRICTED_APPENGINE) {
            return new UnsupportedOperationException("Currently running in an AppEngine restricted environment");
        }
        try {
            Class.forName("javax.naming.directory.InitialDirContext");
            Class.forName("com.sun.jndi.dns.DnsContextFactory");
        }
        catch (ClassNotFoundException e) {
            return e;
        }
        catch (RuntimeException e) {
            return e;
        }
        catch (Error e) {
            return e;
        }
        return null;
    }

    @Override
    @Nullable
    public DnsNameResolver.ResourceResolver newResourceResolver() {
        if (this.unavailabilityCause() != null) {
            return null;
        }
        return new JndiResourceResolver();
    }

    @Override
    @Nullable
    public Throwable unavailabilityCause() {
        return JNDI_UNAVAILABILITY_CAUSE;
    }

    @VisibleForTesting
    static final class JndiResourceResolver
    implements DnsNameResolver.ResourceResolver {
        private static final Logger logger = Logger.getLogger(JndiResourceResolver.class.getName());
        private static final Pattern whitespace = Pattern.compile("\\s+");

        JndiResourceResolver() {
        }

        @Override
        public List<String> resolveTxt(String serviceConfigHostname) throws NamingException {
            JndiResourceResolver.checkAvailable();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "About to query TXT records for {0}", new Object[]{serviceConfigHostname});
            }
            List<String> serviceConfigRawTxtRecords = JndiResourceResolver.getAllRecords("TXT", "dns:///" + serviceConfigHostname);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Found {0} TXT records", new Object[]{serviceConfigRawTxtRecords.size()});
            }
            ArrayList<String> serviceConfigTxtRecords = new ArrayList<String>(serviceConfigRawTxtRecords.size());
            for (String serviceConfigRawTxtRecord : serviceConfigRawTxtRecords) {
                serviceConfigTxtRecords.add(JndiResourceResolver.unquote(serviceConfigRawTxtRecord));
            }
            return Collections.unmodifiableList(serviceConfigTxtRecords);
        }

        @Override
        public List<EquivalentAddressGroup> resolveSrv(DnsNameResolver.AddressResolver addressResolver, String grpclbHostname) throws Exception {
            JndiResourceResolver.checkAvailable();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "About to query SRV records for {0}", new Object[]{grpclbHostname});
            }
            List<String> grpclbSrvRecords = JndiResourceResolver.getAllRecords("SRV", "dns:///" + grpclbHostname);
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Found {0} SRV records", new Object[]{grpclbSrvRecords.size()});
            }
            ArrayList<EquivalentAddressGroup> balancerAddresses = new ArrayList<EquivalentAddressGroup>(grpclbSrvRecords.size());
            Exception first = null;
            Level level = Level.WARNING;
            for (String srvRecord : grpclbSrvRecords) {
                try {
                    SrvRecord record = JndiResourceResolver.parseSrvRecord(srvRecord);
                    List<InetAddress> addrs = addressResolver.resolveAddress(record.host);
                    ArrayList<InetSocketAddress> sockaddrs = new ArrayList<InetSocketAddress>(addrs.size());
                    for (InetAddress addr : addrs) {
                        sockaddrs.add(new InetSocketAddress(addr, record.port));
                    }
                    Attributes attrs = Attributes.newBuilder().set(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY, record.host).build();
                    balancerAddresses.add(new EquivalentAddressGroup(Collections.unmodifiableList(sockaddrs), attrs));
                }
                catch (UnknownHostException e) {
                    logger.log(level, "Can't find address for SRV record " + srvRecord, e);
                    if (first != null) continue;
                    first = e;
                    level = Level.FINE;
                }
                catch (RuntimeException e) {
                    logger.log(level, "Failed to construct SRV record " + srvRecord, e);
                    if (first != null) continue;
                    first = e;
                    level = Level.FINE;
                }
            }
            if (balancerAddresses.isEmpty() && first != null) {
                throw first;
            }
            return Collections.unmodifiableList(balancerAddresses);
        }

        @VisibleForTesting
        static SrvRecord parseSrvRecord(String rawRecord) {
            String[] parts = whitespace.split(rawRecord);
            Verify.verify((parts.length == 4 ? 1 : 0) != 0, (String)"Bad SRV Record: %s", (Object[])new Object[]{rawRecord});
            return new SrvRecord(parts[3], Integer.parseInt(parts[2]));
        }

        @IgnoreJRERequirement
        private static List<String> getAllRecords(String recordType, String name) throws NamingException {
            String[] rrType = new String[]{recordType};
            ArrayList<String> records = new ArrayList<String>();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("com.sun.jndi.ldap.connect.timeout", "5000");
            env.put("com.sun.jndi.ldap.read.timeout", "5000");
            InitialDirContext dirContext = new InitialDirContext(env);
            try {
                javax.naming.directory.Attributes attrs = dirContext.getAttributes(name, rrType);
                NamingEnumeration<? extends Attribute> rrGroups = attrs.getAll();
                try {
                    while (rrGroups.hasMore()) {
                        Attribute rrEntry = rrGroups.next();
                        assert (Arrays.asList(rrType).contains(rrEntry.getID()));
                        NamingEnumeration<?> rrValues = rrEntry.getAll();
                        try {
                            while (rrValues.hasMore()) {
                                records.add(String.valueOf(rrValues.next()));
                            }
                        }
                        catch (NamingException ne) {
                            JndiResourceResolver.closeThenThrow(rrValues, ne);
                        }
                        rrValues.close();
                    }
                }
                catch (NamingException ne) {
                    JndiResourceResolver.closeThenThrow(rrGroups, ne);
                }
                rrGroups.close();
            }
            catch (NamingException ne) {
                JndiResourceResolver.closeThenThrow(dirContext, ne);
            }
            dirContext.close();
            return records;
        }

        @IgnoreJRERequirement
        private static void closeThenThrow(NamingEnumeration<?> namingEnumeration, NamingException e) throws NamingException {
            try {
                namingEnumeration.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            throw e;
        }

        @IgnoreJRERequirement
        private static void closeThenThrow(DirContext ctx, NamingException e) throws NamingException {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            throw e;
        }

        @VisibleForTesting
        static String unquote(String txtRecord) {
            StringBuilder sb = new StringBuilder(txtRecord.length());
            boolean inquote = false;
            for (int i = 0; i < txtRecord.length(); ++i) {
                char c = txtRecord.charAt(i);
                if (!inquote) {
                    if (c == ' ') continue;
                    if (c == '\"') {
                        inquote = true;
                        continue;
                    }
                } else {
                    if (c == '\"') {
                        inquote = false;
                        continue;
                    }
                    if (c == '\\') {
                        c = txtRecord.charAt(++i);
                        assert (c == '\"' || c == '\\');
                    }
                }
                sb.append(c);
            }
            return sb.toString();
        }

        private static void checkAvailable() {
            if (JNDI_UNAVAILABILITY_CAUSE != null) {
                throw new UnsupportedOperationException("JNDI is not currently available", JNDI_UNAVAILABILITY_CAUSE);
            }
        }

        @VisibleForTesting
        static final class SrvRecord {
            final String host;
            final int port;

            SrvRecord(String host, int port) {
                this.host = host;
                this.port = port;
            }
        }
    }
}

