/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.Hashtable;
import java.util.Map;

public class GenericBuffer<T> {
    private final Hashtable<String, GenericBufferPair> buffer;
    private int minAge = 0;
    private int curAge = 0;
    private final int maxCapacity;

    public GenericBuffer(int bufferSize) {
        assert (bufferSize > 0);
        this.buffer = new Hashtable(bufferSize);
        this.maxCapacity = bufferSize;
    }

    public void addValue(T value, String context) {
        assert (value != null && context != null);
        GenericBufferPair storage = this.buffer.get(context);
        if (storage != null) {
            return;
        }
        storage = new GenericBufferPair();
        if (this.buffer.size() == this.maxCapacity) {
            for (Map.Entry<String, GenericBufferPair> e : this.buffer.entrySet()) {
                if (e.getValue().age != this.minAge) continue;
                this.buffer.remove(e.getKey());
                ++this.minAge;
                break;
            }
        }
        storage.age = this.curAge++;
        storage.value = value;
        this.buffer.put(context, storage);
    }

    public T getValue(String context) {
        assert (context != null);
        GenericBufferPair res = this.buffer.get(context);
        if (res == null) {
            return null;
        }
        return res.value;
    }

    private class GenericBufferPair {
        public T value = null;
        public int age = 0;

        private GenericBufferPair() {
        }
    }
}

