/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class DefaultMavenResourcesFiltering
extends AbstractLogEnabled
implements MavenResourcesFiltering,
Initializable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private List defaultNonFilteredFileExtensions;
    private MavenFileFilter mavenFileFilter;

    public void initialize() throws InitializationException {
        this.defaultNonFilteredFileExtensions = new ArrayList(5);
        this.defaultNonFilteredFileExtensions.add("jpg");
        this.defaultNonFilteredFileExtensions.add("jpeg");
        this.defaultNonFilteredFileExtensions.add("gif");
        this.defaultNonFilteredFileExtensions.add("bmp");
        this.defaultNonFilteredFileExtensions.add("png");
    }

    public void filterResources(List resources, File outputDirectory, MavenProject mavenProject, String encoding, List fileFilters, List nonFilteredFileExtensions, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, outputDirectory, mavenProject, encoding, fileFilters, nonFilteredFileExtensions, mavenSession);
        mavenResourcesExecution.setUseDefaultFilterWrappers(true);
        this.filterResources(mavenResourcesExecution);
    }

    public void filterResources(List resources, File outputDirectory, String encoding, List filterWrappers, File resourcesBaseDirectory, List nonFilteredFileExtensions) throws MavenFilteringException {
        MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(resources, outputDirectory, encoding, filterWrappers, resourcesBaseDirectory, nonFilteredFileExtensions);
        this.filterResources(mavenResourcesExecution);
    }

    public boolean filteredFileExtension(String fileName, List userNonFilteredFileExtensions) {
        boolean filteredFileExtension;
        ArrayList nonFilteredFileExtensions = new ArrayList(this.getDefaultNonFilteredFileExtensions());
        if (userNonFilteredFileExtensions != null) {
            nonFilteredFileExtensions.addAll(userNonFilteredFileExtensions);
        }
        boolean bl = filteredFileExtension = !nonFilteredFileExtensions.contains(StringUtils.lowerCase((String)FileUtils.extension((String)fileName)));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("file " + fileName + " has a" + (filteredFileExtension ? " " : " non ") + "filtered file extension");
        }
        return filteredFileExtension;
    }

    public List getDefaultNonFilteredFileExtensions() {
        return this.defaultNonFilteredFileExtensions;
    }

    public void filterResources(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        if (mavenResourcesExecution == null) {
            throw new MavenFilteringException("mavenResourcesExecution cannot be null");
        }
        if (mavenResourcesExecution.getResources() == null) {
            this.getLogger().info("No resources configured skip copying/filtering");
            return;
        }
        if (mavenResourcesExecution.getOutputDirectory() == null) {
            throw new MavenFilteringException("outputDirectory cannot be null");
        }
        if (mavenResourcesExecution.isUseDefaultFilterWrappers()) {
            ArrayList filterWrappers = new ArrayList();
            if (mavenResourcesExecution.getFilterWrappers() != null) {
                filterWrappers.addAll(mavenResourcesExecution.getFilterWrappers());
            }
            filterWrappers.addAll(this.mavenFileFilter.getDefaultFilterWrappers(mavenResourcesExecution.getMavenProject(), mavenResourcesExecution.getFileFilters(), true, mavenResourcesExecution.getMavenSession(), mavenResourcesExecution));
            mavenResourcesExecution.setFilterWrappers(filterWrappers);
        }
        if (mavenResourcesExecution.getEncoding() == null || mavenResourcesExecution.getEncoding().length() < 1) {
            this.getLogger().warn("Using platform encoding (" + ReaderFactory.FILE_ENCODING + " actually) to copy filtered resources, i.e. build is platform dependent!");
        } else {
            this.getLogger().info("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered resources.");
        }
        Iterator i = mavenResourcesExecution.getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (this.getLogger().isDebugEnabled()) {
                String ls = System.getProperty("line.separator");
                StringBuffer debugMessage = new StringBuffer("resource with targetPath " + resource.getTargetPath()).append(ls);
                debugMessage.append("directory " + resource.getDirectory()).append(ls);
                debugMessage.append("excludes " + (resource.getExcludes() == null ? " empty " : resource.getExcludes().toString())).append(ls);
                debugMessage.append("includes " + (resource.getIncludes() == null ? " empty " : resource.getIncludes().toString()));
                this.getLogger().debug(debugMessage.toString());
            }
            String targetPath = resource.getTargetPath();
            File resourceDirectory = new File(resource.getDirectory());
            if (!resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(mavenResourcesExecution.getResourcesBaseDirectory(), resourceDirectory.getPath());
            }
            if (!resourceDirectory.exists()) {
                this.getLogger().info("skip non existing resourceDirectory " + resourceDirectory.getPath());
                continue;
            }
            File outputDirectory = mavenResourcesExecution.getOutputDirectory();
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new MavenFilteringException("Cannot create resource output directory: " + outputDirectory);
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resourceDirectory);
            String[] includes = null;
            includes = resource.getIncludes() != null && !resource.getIncludes().isEmpty() ? resource.getIncludes().toArray(EMPTY_STRING_ARRAY) : DEFAULT_INCLUDES;
            scanner.setIncludes(includes);
            String[] excludes = null;
            if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                excludes = resource.getExcludes().toArray(EMPTY_STRING_ARRAY);
                scanner.setExcludes(excludes);
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            if (mavenResourcesExecution.isIncludeEmptyDirs()) {
                try {
                    File targetDirectory = targetPath == null ? outputDirectory : new File(outputDirectory, targetPath);
                    this.copyDirectoryLayout(resourceDirectory, targetDirectory, scanner);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Cannot copy directory structure from " + resourceDirectory.getPath() + " to " + outputDirectory.getPath());
                }
            }
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLogger().info("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath));
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name;
                String destination = name = j.next();
                if (targetPath != null) {
                    destination = targetPath + "/" + name;
                }
                File source = new File(resourceDirectory, name);
                File destinationFile = new File(destination);
                if (!destinationFile.isAbsolute()) {
                    destinationFile = new File(outputDirectory, destination);
                }
                if (!destinationFile.getParentFile().exists()) {
                    destinationFile.getParentFile().mkdirs();
                }
                boolean filteredExt = this.filteredFileExtension(source.getName(), mavenResourcesExecution.getNonFilteredFileExtensions());
                this.mavenFileFilter.copyFile(source, destinationFile, resource.isFiltering() && filteredExt, mavenResourcesExecution.getFilterWrappers(), mavenResourcesExecution.getEncoding(), mavenResourcesExecution.isOverwrite());
            }
        }
    }

    private void copyDirectoryLayout(File sourceDirectory, File destinationDirectory, DirectoryScanner scanner) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        List<String> includedDirectories = Arrays.asList(scanner.getIncludedDirectories());
        Iterator<String> i = includedDirectories.iterator();
        while (i.hasNext()) {
            String name = i.next();
            File source = new File(sourceDirectory, name);
            if (source.equals(sourceDirectory)) continue;
            File destination = new File(destinationDirectory, name);
            destination.mkdirs();
        }
    }
}

