/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey.subsystem;

import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.Condition;
import org.sonatype.nexus.client.core.condition.NexusStatusConditions;
import org.sonatype.nexus.client.core.spi.SubsystemFactory;
import org.sonatype.nexus.client.core.spi.subsystem.repository.RepositoryFactory;
import org.sonatype.nexus.client.core.subsystem.repository.Repositories;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyRepositories;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

@Named
@Singleton
public class JerseyRepositoriesFactory
implements SubsystemFactory<Repositories, JerseyNexusClient> {
    private final Set<RepositoryFactory> repositoryFactories;

    @Inject
    public JerseyRepositoriesFactory(Set<RepositoryFactory> repositoryFactories) {
        this.repositoryFactories = repositoryFactories;
    }

    @Override
    public Condition availableWhen() {
        return NexusStatusConditions.anyModern();
    }

    @Override
    public Class<Repositories> getType() {
        return Repositories.class;
    }

    @Override
    public Repositories create(JerseyNexusClient nexusClient) {
        return new JerseyRepositories(nexusClient, this.repositoryFactories);
    }
}

