/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTree;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=DependencyTreeBuilder.class)
public class DefaultDependencyTreeBuilder
extends AbstractLogEnabled
implements DependencyTreeBuilder {
    @Requirement
    private ArtifactFactory factory;
    @Requirement
    private ArtifactMetadataSource metadataSource;
    @Requirement
    private ArtifactCollector collector;
    private ArtifactResolutionResult result;

    public DependencyTree buildDependencyTree(MavenProject project, ArtifactRepository repository, ArtifactFactory factory, ArtifactMetadataSource metadataSource, ArtifactCollector collector) throws DependencyTreeBuilderException {
        DependencyNode rootNode = this.buildDependencyTree(project, repository, factory, metadataSource, null, collector);
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        rootNode.accept(collectingVisitor);
        return new DependencyTree(rootNode, collectingVisitor.getNodes());
    }

    public DependencyNode buildDependencyTree(MavenProject project, ArtifactRepository repository, ArtifactFactory factory, ArtifactMetadataSource metadataSource, ArtifactFilter filter, ArtifactCollector collector) throws DependencyTreeBuilderException {
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener(this.getLogger());
        try {
            Map managedVersions = project.getManagedVersionMap();
            Set dependencyArtifacts = project.getDependencyArtifacts();
            if (dependencyArtifacts == null) {
                dependencyArtifacts = project.createArtifacts(factory, null, null);
            }
            this.getLogger().debug("Dependency tree resolution listener events:");
            this.result = collector.collect(dependencyArtifacts, project.getArtifact(), managedVersions, repository, project.getRemoteArtifactRepositories(), metadataSource, filter, Collections.singletonList(listener));
            return listener.getRootNode();
        }
        catch (ArtifactResolutionException exception) {
            throw new DependencyTreeBuilderException("Cannot build project dependency tree", exception);
        }
        catch (InvalidDependencyVersionException e) {
            throw new DependencyTreeBuilderException("Invalid dependency version for artifact " + project.getArtifact());
        }
    }

    public DependencyNode buildDependencyTree(MavenProject project) throws DependencyTreeBuilderException {
        return this.buildDependencyTree(project, project.getProjectBuilderConfiguration().getLocalRepository(), this.factory, this.metadataSource, null, this.collector);
    }

    public DependencyNode buildDependencyTree(MavenProject project, ArtifactRepository repository, ArtifactFilter filter) throws DependencyTreeBuilderException {
        return this.buildDependencyTree(project, repository, this.factory, this.metadataSource, filter, this.collector);
    }

    protected ArtifactResolutionResult getArtifactResolutionResult() {
        return this.result;
    }
}

