/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.HSV;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import com.github.ajalt.mordant.Ansi16ColorCode;
import com.github.ajalt.mordant.Ansi256ColorCode;
import com.github.ajalt.mordant.AnsiCode;
import com.github.ajalt.mordant.AnsiColorCode;
import com.github.ajalt.mordant.AnsiRGBColorCode;
import com.github.ajalt.mordant.DisabledAnsiCode;
import com.github.ajalt.mordant.DisabledAnsiColorCode;
import com.github.ajalt.mordant.TermColors$WhenMappings;
import com.github.ajalt.mordant.TerminalCapabilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0001gB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0002J\u0010\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u00020CH\u0002J&\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020C2\u0006\u0010I\u001a\u00020C2\u0006\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020CJ\u000e\u0010L\u001a\u00020\u00062\u0006\u0010L\u001a\u00020MJ\u000e\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020CJ\u000e\u0010P\u001a\u00020(2\u0006\u0010O\u001a\u00020CJ\u000e\u0010Q\u001a\u00020(2\u0006\u0010O\u001a\u00020CJ\u000e\u0010R\u001a\u00020(2\u0006\u0010O\u001a\u00020CJ\u000e\u0010!\u001a\u00020\u00062\u0006\u0010S\u001a\u00020TJ\u001e\u0010U\u001a\u00020\u00062\u0006\u0010V\u001a\u00020C2\u0006\u0010W\u001a\u00020C2\u0006\u0010X\u001a\u00020CJ\u001e\u0010Y\u001a\u00020\u00062\u0006\u0010V\u001a\u00020C2\u0006\u0010W\u001a\u00020C2\u0006\u0010Z\u001a\u00020CJ\u001e\u0010[\u001a\u00020\u00062\u0006\u0010X\u001a\u00020T2\u0006\u0010\\\u001a\u00020T2\u0006\u0010]\u001a\u00020TJ\u0018\u0010^\u001a\u00020(2\u0006\u0010_\u001a\u00020(2\u0006\u0010O\u001a\u00020CH\u0002J\u001e\u0010`\u001a\u00020\u00062\u0006\u0010a\u001a\u00020C2\u0006\u0010b\u001a\u00020C2\u0006\u0010]\u001a\u00020CJ\u000e\u0010`\u001a\u00020\u00062\u0006\u0010c\u001a\u00020(J\u001e\u0010d\u001a\u00020\u00062\u0006\u0010e\u001a\u00020T2\u0006\u0010J\u001a\u00020T2\u0006\u0010f\u001a\u00020TR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000eR\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0011\u0010#\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0011\u0010%\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000eR\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u000eR\u0011\u0010-\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\bR\u0011\u00103\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\bR\u0011\u00105\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u000eR\u0011\u00107\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010*R\u0011\u00109\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u000eR\u0011\u0010;\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u000eR\u0011\u0010=\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\bR\u0011\u0010?\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\b\u00a8\u0006h"}, d2={"Lcom/github/ajalt/mordant/TermColors;", "", "level", "Lcom/github/ajalt/mordant/TermColors$Level;", "(Lcom/github/ajalt/mordant/TermColors$Level;)V", "black", "Lcom/github/ajalt/mordant/AnsiColorCode;", "getBlack", "()Lcom/github/ajalt/mordant/AnsiColorCode;", "blue", "getBlue", "bold", "Lcom/github/ajalt/mordant/AnsiCode;", "getBold", "()Lcom/github/ajalt/mordant/AnsiCode;", "brightBlue", "getBrightBlue", "brightCyan", "getBrightCyan", "brightGreen", "getBrightGreen", "brightMagenta", "getBrightMagenta", "brightRed", "getBrightRed", "brightWhite", "getBrightWhite", "brightYellow", "getBrightYellow", "cyan", "getCyan", "dim", "getDim", "gray", "getGray", "green", "getGreen", "hidden", "getHidden", "hideCursor", "", "getHideCursor", "()Ljava/lang/String;", "inverse", "getInverse", "italic", "getItalic", "getLevel", "()Lcom/github/ajalt/mordant/TermColors$Level;", "magenta", "getMagenta", "red", "getRed", "reset", "getReset", "showCursor", "getShowCursor", "strikethrough", "getStrikethrough", "underline", "getUnderline", "white", "getWhite", "yellow", "getYellow", "ansi", "open", "", "close", "ansi16", "code", "cmyk", "c", "m", "y", "k", "color", "Lcom/github/ajalt/colormath/ConvertibleColor;", "cursorDown", "count", "cursorLeft", "cursorRight", "cursorUp", "fraction", "", "hsl", "h", "s", "l", "hsv", "v", "lab", "a", "b", "moveCursor", "dir", "rgb", "r", "g", "hex", "xyz", "x", "z", "Level", "mordant"})
public final class TermColors {
    @NotNull
    private final Level level;

    @NotNull
    public final AnsiColorCode getBlack() {
        return this.ansi16(30);
    }

    @NotNull
    public final AnsiColorCode getRed() {
        return this.ansi16(31);
    }

    @NotNull
    public final AnsiColorCode getGreen() {
        return this.ansi16(32);
    }

    @NotNull
    public final AnsiColorCode getYellow() {
        return this.ansi16(33);
    }

    @NotNull
    public final AnsiColorCode getBlue() {
        return this.ansi16(34);
    }

    @NotNull
    public final AnsiColorCode getMagenta() {
        return this.ansi16(35);
    }

    @NotNull
    public final AnsiColorCode getCyan() {
        return this.ansi16(36);
    }

    @NotNull
    public final AnsiColorCode getWhite() {
        return this.ansi16(37);
    }

    @NotNull
    public final AnsiColorCode getGray() {
        return this.ansi16(90);
    }

    @NotNull
    public final AnsiColorCode getBrightRed() {
        return this.ansi16(91);
    }

    @NotNull
    public final AnsiColorCode getBrightGreen() {
        return this.ansi16(92);
    }

    @NotNull
    public final AnsiColorCode getBrightYellow() {
        return this.ansi16(93);
    }

    @NotNull
    public final AnsiColorCode getBrightBlue() {
        return this.ansi16(94);
    }

    @NotNull
    public final AnsiColorCode getBrightMagenta() {
        return this.ansi16(95);
    }

    @NotNull
    public final AnsiColorCode getBrightCyan() {
        return this.ansi16(96);
    }

    @NotNull
    public final AnsiColorCode getBrightWhite() {
        return this.ansi16(97);
    }

    @NotNull
    public final AnsiCode getReset() {
        return this.level == Level.NONE ? (AnsiCode)DisabledAnsiCode.INSTANCE : new AnsiCode(0, 0);
    }

    @NotNull
    public final AnsiCode getBold() {
        return this.ansi(1, 22);
    }

    @NotNull
    public final AnsiCode getDim() {
        return this.ansi(2, 22);
    }

    @NotNull
    public final AnsiCode getItalic() {
        return this.ansi(3, 23);
    }

    @NotNull
    public final AnsiCode getUnderline() {
        return this.ansi(4, 24);
    }

    @NotNull
    public final AnsiCode getInverse() {
        return this.ansi(7, 27);
    }

    @NotNull
    public final AnsiCode getHidden() {
        return this.ansi(8, 28);
    }

    @NotNull
    public final AnsiCode getStrikethrough() {
        return this.ansi(9, 29);
    }

    @NotNull
    public final AnsiColorCode rgb(@NotNull String hex) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        return this.color((ConvertibleColor)new RGB(hex));
    }

    @NotNull
    public final AnsiColorCode rgb(int r, int g, int b) {
        return this.color((ConvertibleColor)new RGB(r, g, b));
    }

    @NotNull
    public final AnsiColorCode hsl(int h, int s, int l) {
        return this.color((ConvertibleColor)new HSL(h, s, l));
    }

    @NotNull
    public final AnsiColorCode hsv(int h, int s, int v) {
        return this.color((ConvertibleColor)new HSV(h, s, v));
    }

    @NotNull
    public final AnsiColorCode cmyk(int c, int m, int y, int k) {
        return this.color((ConvertibleColor)new CMYK(c, m, y, k));
    }

    @NotNull
    public final AnsiColorCode gray(double fraction) {
        int n;
        double d = fraction;
        int n2 = n = d >= 0.0 && d <= 1.0 ? 1 : 0;
        if (n == 0) {
            boolean bl = false;
            String string = "fraction must be in the range [0, 1]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int it = n = (int)Math.round((double)255 * fraction);
        boolean bl = false;
        return this.rgb(it, it, it);
    }

    @NotNull
    public final AnsiColorCode xyz(double x, double y, double z) {
        return this.color((ConvertibleColor)new XYZ(x, y, z));
    }

    @NotNull
    public final AnsiColorCode lab(double l, double a, double b) {
        return this.color((ConvertibleColor)new LAB(l, a, b));
    }

    @NotNull
    public final String cursorUp(int count) {
        String string = count < 0 ? "B" : "A";
        TermColors termColors = this;
        int n = Math.abs(count);
        return termColors.moveCursor(string, n);
    }

    @NotNull
    public final String cursorDown(int count) {
        String string = count < 0 ? "A" : "B";
        TermColors termColors = this;
        int n = Math.abs(count);
        return termColors.moveCursor(string, n);
    }

    @NotNull
    public final String cursorLeft(int count) {
        String string = count < 0 ? "C" : "D";
        TermColors termColors = this;
        int n = Math.abs(count);
        return termColors.moveCursor(string, n);
    }

    @NotNull
    public final String cursorRight(int count) {
        String string = count < 0 ? "D" : "C";
        TermColors termColors = this;
        int n = Math.abs(count);
        return termColors.moveCursor(string, n);
    }

    @NotNull
    public final String getHideCursor() {
        return this.level == Level.NONE ? "" : "\u001b[?25l";
    }

    @NotNull
    public final String getShowCursor() {
        return this.level == Level.NONE ? "" : "\u001b[?25h";
    }

    private final String moveCursor(String dir, int count) {
        return count == 0 || this.level == Level.NONE ? "" : "\u001b[" + count + dir;
    }

    private final AnsiColorCode ansi16(int code) {
        return this.level == Level.NONE ? (AnsiColorCode)DisabledAnsiColorCode.INSTANCE : (AnsiColorCode)new Ansi16ColorCode(code);
    }

    private final AnsiCode ansi(int open, int close) {
        return this.level == Level.NONE ? (AnsiCode)DisabledAnsiCode.INSTANCE : new AnsiCode(open, close);
    }

    @NotNull
    public final AnsiColorCode color(@NotNull ConvertibleColor color) {
        AnsiColorCode ansiColorCode;
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        switch (TermColors$WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
            case 1: {
                ansiColorCode = DisabledAnsiColorCode.INSTANCE;
                break;
            }
            case 2: {
                ansiColorCode = new Ansi16ColorCode(color.toAnsi16().getCode());
                break;
            }
            case 3: {
                if (color instanceof Ansi16) {
                    ansiColorCode = new Ansi16ColorCode(((Ansi16)color).getCode());
                    break;
                }
                ansiColorCode = new Ansi256ColorCode(color.toAnsi256().getCode());
                break;
            }
            case 4: {
                RGB rGB;
                ConvertibleColor convertibleColor = color;
                if (convertibleColor instanceof Ansi16) {
                    ansiColorCode = new Ansi16ColorCode(((Ansi16)color).getCode());
                    break;
                }
                if (convertibleColor instanceof Ansi256) {
                    ansiColorCode = new Ansi256ColorCode(((Ansi256)color).getCode());
                    break;
                }
                RGB $receiver = rGB = color.toRGB();
                boolean bl = false;
                ansiColorCode = new AnsiRGBColorCode($receiver.getR(), $receiver.getG(), $receiver.getB());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ansiColorCode;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public TermColors(@NotNull Level level) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        this.level = level;
    }

    public /* synthetic */ TermColors(Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            level = TerminalCapabilities.detectANSISupport$default(TerminalCapabilities.INSTANCE, null, 1, null);
        }
        this(level);
    }

    public TermColors() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/ajalt/mordant/TermColors$Level;", "", "(Ljava/lang/String;I)V", "NONE", "ANSI16", "ANSI256", "TRUECOLOR", "mordant"})
    public static final class Level
    extends Enum<Level> {
        public static final /* enum */ Level NONE;
        public static final /* enum */ Level ANSI16;
        public static final /* enum */ Level ANSI256;
        public static final /* enum */ Level TRUECOLOR;
        private static final /* synthetic */ Level[] $VALUES;

        static {
            Level[] levelArray = new Level[4];
            Level[] levelArray2 = levelArray;
            levelArray[0] = NONE = new Level();
            levelArray[1] = ANSI16 = new Level();
            levelArray[2] = ANSI256 = new Level();
            levelArray[3] = TRUECOLOR = new Level();
            $VALUES = levelArray;
        }

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String string) {
            return Enum.valueOf(Level.class, string);
        }
    }
}

