/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.dir;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.exceptions.EmptyArchiveException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.components.io.attributes.SymlinkUtils;
import org.codehaus.plexus.components.io.functions.SymlinkDestinationSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class DirectoryArchiver
extends AbstractArchiver {
    private final List<Runnable> directoryChmods = new ArrayList<Runnable>();

    public void resetArchiver() throws IOException {
        this.cleanUp();
    }

    @Override
    public void execute() throws ArchiverException, IOException {
        ResourceIterator iter = this.getResources();
        if (!iter.hasNext()) {
            throw new EmptyArchiveException("archive cannot be empty");
        }
        File destDirectory = this.getDestFile();
        if (destDirectory == null) {
            throw new ArchiverException("You must set the destination directory.");
        }
        if (destDirectory.exists() && !destDirectory.isDirectory()) {
            throw new ArchiverException(destDirectory + " is not a directory.");
        }
        if (destDirectory.exists() && !destDirectory.canWrite()) {
            throw new ArchiverException(destDirectory + " is not writable.");
        }
        this.getLogger().info("Copying files to " + destDirectory.getAbsolutePath());
        try {
            while (iter.hasNext()) {
                ArchiveEntry f = iter.next();
                if (ResourceUtils.isSame(f.getResource(), destDirectory)) {
                    throw new ArchiverException("The destination directory cannot include itself.");
                }
                String fileName = f.getName();
                String destDir = destDirectory.getCanonicalPath();
                fileName = destDir + File.separator + fileName;
                PlexusIoResource resource = f.getResource();
                if (resource instanceof SymlinkDestinationSupplier) {
                    String dest = ((SymlinkDestinationSupplier)resource).getSymlinkDestination();
                    File target = new File(dest);
                    File symlink = new File(fileName);
                    DirectoryArchiver.makeParentDirectories(symlink);
                    SymlinkUtils.createSymbolicLink((File)symlink, (File)target);
                    continue;
                }
                this.copyFile(f, fileName);
            }
            for (Runnable directoryChmod : this.directoryChmods) {
                directoryChmod.run();
            }
            this.directoryChmods.clear();
        }
        catch (IOException ioe) {
            String message = "Problem copying files : " + ioe.getMessage();
            throw new ArchiverException(message, ioe);
        }
    }

    protected void copyFile(final ArchiveEntry entry, String vPath) throws ArchiverException, IOException {
        long outLastModified;
        if (vPath.length() <= 0) {
            return;
        }
        PlexusIoResource in = entry.getResource();
        final File outFile = new File(vPath);
        final long inLastModified = in.getLastModified();
        if (ResourceUtils.isUptodate(inLastModified, outLastModified = outFile.lastModified())) {
            return;
        }
        if (!in.isDirectory()) {
            DirectoryArchiver.makeParentDirectories(outFile);
            ResourceUtils.copyFile(entry.getInputStream(), outFile);
            this.setFileModes(entry, outFile, inLastModified);
        } else {
            if (outFile.exists()) {
                if (!outFile.isDirectory()) {
                    throw new ArchiverException("Expected directory and found file at copy destination of " + in.getName() + " to " + outFile);
                }
            } else if (!outFile.mkdirs()) {
                throw new ArchiverException("Unable to create directory or parent directory of " + outFile);
            }
            this.directoryChmods.add(new Runnable(){

                @Override
                public void run() {
                    DirectoryArchiver.this.setFileModes(entry, outFile, inLastModified);
                }
            });
        }
    }

    private static void makeParentDirectories(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ArchiverException("Unable to create directory or parent directory of " + file);
        }
    }

    private void setFileModes(ArchiveEntry entry, File outFile, long inLastModified) {
        if (!this.isIgnorePermissions()) {
            ArchiveEntryUtils.chmod(outFile, entry.getMode());
        }
        if (this.getLastModifiedDate() == null) {
            outFile.setLastModified(inLastModified == 0L ? System.currentTimeMillis() : inLastModified);
        } else {
            outFile.setLastModified(this.getLastModifiedDate().getTime());
        }
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.setIncludeEmptyDirs(false);
        this.setIncludeEmptyDirs(true);
    }

    @Override
    protected void close() throws IOException {
    }

    @Override
    protected String getArchiveType() {
        return "directory";
    }
}

