/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.sonatype.sisu.charger.internal.Check;
import org.sonatype.spice.zapper.CodecSelector;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.ZFile;
import org.sonatype.spice.zapper.codec.Codec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingCodecSelector
implements CodecSelector {
    private final Map<Pattern, Codec> codecs;

    public MatchingCodecSelector() {
        this(new LinkedHashMap<Pattern, Codec>());
    }

    public MatchingCodecSelector(Map<Pattern, Codec> codecs) {
        this.codecs = Collections.unmodifiableMap(codecs);
    }

    @Override
    public List<Codec> selectCodecs(ZFile zfile) {
        if (this.codecs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Codec> result = new ArrayList<Codec>();
        for (Map.Entry<Pattern, Codec> entry : this.codecs.entrySet()) {
            if (!entry.getKey().matcher(((Path)zfile.getIdentifier()).stringValue()).matches()) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public static MatchingCodecSelectorBuilder builder() {
        return new MatchingCodecSelectorBuilder();
    }

    public static class MatchingCodecSelectorBuilder {
        private final LinkedHashMap<Pattern, Codec> codecs = new LinkedHashMap();

        public MatchingCodecSelectorBuilder add(String regex, Codec codec) {
            return this.add(Pattern.compile((String)Check.notNull((Object)regex, String.class)), codec);
        }

        public MatchingCodecSelectorBuilder add(Pattern regex, Codec codec) {
            this.codecs.put((Pattern)Check.notNull((Object)regex, Pattern.class), (Codec)Check.notNull((Object)codec, Codec.class));
            return this;
        }

        public MatchingCodecSelector build() {
            return new MatchingCodecSelector(this.codecs);
        }
    }
}

