/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;

public class DistributionManagementCheck {
    private DistributionManagement distributionManagement;

    public DistributionManagementCheck(MavenProject project) {
        this.distributionManagement = project.getOriginalModel().getDistributionManagement();
    }

    public void execute(boolean isAllowRepository, boolean isAllowSnapshotRepository, boolean isAllowSite) throws EnforcerRuleException {
        if (this.hasDistributionManagement()) {
            if (!isAllowRepository && this.hasRepository()) {
                throw new EnforcerRuleException("You have defined a repository in distributionManagement.");
            }
            if (!isAllowSnapshotRepository && this.hasSnapshotRepository()) {
                throw new EnforcerRuleException("You have defined a snapshotRepository in distributionManagement.");
            }
            if (!isAllowSite && this.hasSite()) {
                throw new EnforcerRuleException("You have defined a site in distributionManagement.");
            }
        }
    }

    private boolean hasRepository() {
        return this.getDistributionManagement().getRepository() != null;
    }

    public DistributionManagement getDistributionManagement() {
        return this.distributionManagement;
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.distributionManagement = distributionManagement;
    }

    private boolean hasSnapshotRepository() {
        return this.getDistributionManagement().getSnapshotRepository() != null;
    }

    private boolean hasSite() {
        return this.getDistributionManagement().getSite() != null;
    }

    private boolean hasDistributionManagement() {
        return this.getDistributionManagement() != null;
    }
}

