/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/SpacingAroundRangeOperatorRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class SpacingAroundRangeOperatorRule
extends Rule {
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtTokens.RANGE)) {
            PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)node.getPsi(), (boolean)true);
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)node.getPsi(), (boolean)true);
            if (prevLeaf instanceof PsiWhiteSpace && nextLeaf instanceof PsiWhiteSpace) {
                emit.invoke((Object)node.getStartOffset(), (Object)"Unexpected spacing around \"..\"", (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpace)prevLeaf).getNode());
                    ((PsiWhiteSpace)nextLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpace)nextLeaf).getNode());
                }
            } else if (prevLeaf instanceof PsiWhiteSpace) {
                emit.invoke((Object)((PsiWhiteSpace)prevLeaf).getNode().getStartOffset(), (Object)"Unexpected spacing before \"..\"", (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpace)prevLeaf).getNode());
                }
            } else if (nextLeaf instanceof PsiWhiteSpace) {
                emit.invoke((Object)((PsiWhiteSpace)nextLeaf).getNode().getStartOffset(), (Object)"Unexpected spacing after \"..\"", (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)nextLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpace)nextLeaf).getNode());
                }
            }
        }
    }

    public SpacingAroundRangeOperatorRule() {
        super("range-spacing");
    }
}

