/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.ktlint.ruleset.standard;

import com.github.shyiko.ktlint.core.Rule;
import com.github.shyiko.ktlint.ruleset.standard.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jk\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2K\u0010\n\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bH\u0002Je\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042K\u0010\n\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/github/shyiko/ktlint/ruleset/standard/NoTrailingSpacesRule;", "Lcom/github/shyiko/ktlint/core/Rule;", "()V", "checkForTrailingSpaces", "", "lines", "", "", "offset", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "errorMessage", "canBeAutoCorrected", "", "visit", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "ktlint-ruleset-standard"})
public final class NoTrailingSpacesRule
extends Rule {
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (node instanceof PsiWhiteSpace) {
            boolean violated;
            List lines = StringsKt.split$default((CharSequence)node.getText(), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            if (lines.size() > 1) {
                boolean violated2 = this.checkForTrailingSpaces(PackageKt.head(lines), node.getStartOffset(), emit);
                if (violated2 && autoCorrect) {
                    ((LeafPsiElement)node).rawReplaceWithText(StringsKt.repeat((CharSequence)"\n", (int)(lines.size() - 1)) + (String)CollectionsKt.last((List)lines));
                }
            } else if (PsiTreeUtil.nextLeaf((PsiElement)((PsiElement)node)) == null && (violated = this.checkForTrailingSpaces(lines, node.getStartOffset(), emit)) && autoCorrect) {
                ((LeafPsiElement)node).rawReplaceWithText(StringsKt.repeat((CharSequence)"\n", (int)(lines.size() - 1)));
            }
        }
    }

    private final boolean checkForTrailingSpaces(List<String> lines, int offset, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        boolean violated = false;
        int violationOffset = offset;
        Iterable $receiver$iv = lines;
        for (Object element$iv : $receiver$iv) {
            String line = (String)element$iv;
            CharSequence charSequence = line;
            if (!(charSequence.length() == 0)) {
                emit.invoke((Object)violationOffset, (Object)"Trailing space(s)", (Object)true);
                violated = true;
            }
            violationOffset += line.length() + 1;
        }
        return violated;
    }

    public NoTrailingSpacesRule() {
        super("no-trailing-spaces");
    }
}

