/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.impl.neomedia.codec.REDBlock;
import org.jitsi.impl.neomedia.rtp.MediaStreamTrackReceiver;
import org.jitsi.impl.neomedia.rtp.TransportCCEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.format.MediaFormat;

public abstract class AbstractMediaStream
implements MediaStream {
    private String name;
    private final Map<String, Object> properties = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected RTPTranslator rtpTranslator;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void assertDirection(MediaDirection direction, MediaDirection deviceDirection, String illegalArgumentExceptionMessage) throws IllegalArgumentException {
        if (direction != null && !direction.and(deviceDirection).equals((Object)direction)) {
            throw new IllegalArgumentException(illegalArgumentExceptionMessage);
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    protected void handleAttributes(MediaFormat format, Map<String, String> attrs) {
    }

    public void injectPacket(RawPacket pkt, boolean data) throws TransmissionFailedException {
        this.injectPacket(pkt, data, null);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        if (value == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, value);
        }
    }

    @Override
    public void setRTPTranslator(RTPTranslator rtpTranslator) {
        if (this.rtpTranslator != rtpTranslator) {
            this.rtpTranslator = rtpTranslator;
        }
    }

    @Override
    public RTPTranslator getRTPTranslator() {
        return this.rtpTranslator;
    }

    @Override
    public TransformEngineChain getTransformEngineChain() {
        return null;
    }

    @Override
    public byte getDynamicRTPPayloadType(String codec) {
        return -1;
    }

    @Override
    public MediaStreamTrackReceiver getMediaStreamTrackReceiver() {
        return null;
    }

    @Override
    public MediaFormat getFormat(byte pt) {
        return null;
    }

    @Override
    public void setTransportCCEngine(TransportCCEngine engine) {
    }

    @Override
    public REDBlock getPrimaryREDBlock(ByteArrayBuffer baf) {
        return null;
    }

    @Override
    public REDBlock getPrimaryREDBlock(RawPacket pkt) {
        return null;
    }
}

