/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.felix.obrplugin.Capability;
import org.apache.felix.obrplugin.Category;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ExtractBindexInfo;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.felix.obrplugin.PElement;
import org.apache.felix.obrplugin.Require;
import org.apache.felix.obrplugin.ResourcesBundle;
import org.apache.felix.obrplugin.XmlHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ObrUpdate {
    static SimpleDateFormat m_format = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
    private Log m_logger;
    private URI m_repositoryXml;
    private URI m_obrXml;
    private MavenProject m_project;
    private Config m_userConfig;
    private DocumentBuilder m_documentBuilder;
    private Document m_repositoryDoc;
    private ResourcesBundle m_resourceBundle;
    private URI m_baseURI;

    public ObrUpdate(URI repositoryXml, URI obrXml, MavenProject project, String mavenRepositoryPath, Config userConfig, Log logger) {
        this.m_repositoryXml = repositoryXml;
        this.m_obrXml = obrXml;
        this.m_project = project;
        this.m_logger = logger;
        this.m_userConfig = userConfig;
        this.m_baseURI = userConfig.isRemoteFile() ? ObrUtils.toFileURI(mavenRepositoryPath) : this.m_repositoryXml;
        this.m_documentBuilder = this.initDocumentBuilder();
    }

    public void updateRepository(URI bundleJar, URI sourceJar, URI docJar) throws MojoExecutionException {
        ExtractBindexInfo bindexExtractor;
        URI resourceURI;
        this.m_logger.debug((CharSequence)(" (f) repositoryXml = " + this.m_repositoryXml));
        this.m_logger.debug((CharSequence)(" (f) bundleJar = " + bundleJar));
        this.m_logger.debug((CharSequence)(" (f) sourceJar = " + sourceJar));
        this.m_logger.debug((CharSequence)(" (f) obrXml = " + this.m_obrXml));
        if (this.m_repositoryDoc == null) {
            return;
        }
        this.m_resourceBundle = new ResourcesBundle(this.m_logger);
        File bundleFile = new File(bundleJar);
        if (bundleFile.exists()) {
            resourceURI = this.m_userConfig.getRemoteBundle();
            if (null == resourceURI) {
                resourceURI = bundleJar;
                if (this.m_userConfig.isPathRelative()) {
                    resourceURI = ObrUtils.getRelativeURI(this.m_baseURI, resourceURI);
                }
            }
            if (this.m_userConfig.isRemoteFile()) {
                this.m_logger.info((CharSequence)("Deploying " + resourceURI));
            } else {
                this.m_logger.info((CharSequence)("Installing " + resourceURI));
            }
        } else {
            this.m_logger.error((CharSequence)("file doesn't exist: " + bundleJar));
            return;
        }
        this.m_resourceBundle.setSize(String.valueOf(bundleFile.length()));
        this.m_resourceBundle.setUri(resourceURI.toASCIIString());
        if (this.m_obrXml != null) {
            this.m_logger.info((CharSequence)("Adding " + this.m_obrXml));
            Document obrXmlDoc = this.parseFile(this.m_obrXml, this.m_documentBuilder);
            if (obrXmlDoc == null) {
                return;
            }
            Element obrXmlRoot = obrXmlDoc.getDocumentElement();
            this.sortObrXml(obrXmlRoot);
        }
        try {
            bindexExtractor = new ExtractBindexInfo(this.m_repositoryXml, bundleJar.getPath());
        }
        catch (MojoExecutionException e) {
            this.m_logger.error((CharSequence)"unable to build Bindex informations");
            e.printStackTrace();
            throw new MojoExecutionException("BindexException");
        }
        String sourcePath = this.relativisePath(sourceJar);
        String docPath = this.relativisePath(docJar);
        this.m_resourceBundle.construct(this.m_project, bindexExtractor, sourcePath, docPath);
        Element rootElement = this.m_repositoryDoc.getDocumentElement();
        if (!this.walkOnTree(rootElement)) {
            String id = this.m_resourceBundle.getId();
            this.searchRepository(rootElement, id);
        }
    }

    private String relativisePath(URI uri) {
        if (null != uri) {
            if (this.m_userConfig.isPathRelative()) {
                return ObrUtils.getRelativeURI(this.m_baseURI, uri).toASCIIString();
            }
            return uri.toASCIIString();
        }
        return null;
    }

    public void writeRepositoryXml() throws MojoExecutionException {
        this.m_logger.info((CharSequence)"Writing OBR metadata");
        this.writeToFile(this.m_repositoryXml, this.m_repositoryDoc);
    }

    private DocumentBuilder initDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.m_logger.error((CharSequence)"unable to create a new xml document");
            e.printStackTrace();
        }
        return documentBuilder;
    }

    public boolean parseRepositoryXml() throws MojoExecutionException {
        File fout = new File(this.m_repositoryXml);
        if (!fout.exists()) {
            Document doc = this.m_documentBuilder.newDocument();
            Date d = new Date();
            d.setTime(System.currentTimeMillis());
            Element root = doc.createElement("repository");
            root.setAttribute("lastmodified", m_format.format(d));
            root.setAttribute("name", "MyRepository");
            try {
                this.writeToFile(this.m_repositoryXml, root);
            }
            catch (MojoExecutionException e) {
                e.printStackTrace();
                throw new MojoExecutionException("IOException");
            }
        }
        this.m_repositoryDoc = this.parseFile(this.m_repositoryXml, this.m_documentBuilder);
        return null != this.m_repositoryDoc;
    }

    private Document parseFile(URI filename, DocumentBuilder documentBuilder) {
        if (documentBuilder == null) {
            return null;
        }
        this.m_logger.info((CharSequence)("Parsing " + filename));
        Document doc = null;
        try {
            doc = documentBuilder.parse(new File(filename));
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            this.m_logger.error((CharSequence)("cannot open file: " + filename));
            e.printStackTrace();
            return null;
        }
        return doc;
    }

    private void sortObrXml(Node node) {
        if (node.getNodeName().compareTo("require") == 0) {
            Require newRequireNode = new Require();
            NamedNodeMap list = node.getAttributes();
            try {
                newRequireNode.setExtend(list.getNamedItem("extend").getNodeValue());
                newRequireNode.setMultiple(list.getNamedItem("multiple").getNodeValue());
                newRequireNode.setOptional(list.getNamedItem("optional").getNodeValue());
                newRequireNode.setFilter(list.getNamedItem("filter").getNodeValue());
                newRequireNode.setName(list.getNamedItem("name").getNodeValue());
            }
            catch (NullPointerException e) {
                this.m_logger.error((CharSequence)"the obr.xml file seems to be invalid in a \"require\" tag (one or more attributes are missing)");
            }
            newRequireNode.setValue(XmlHelper.getTextContent(node));
            this.m_resourceBundle.addRequire(newRequireNode);
        } else if (node.getNodeName().compareTo("capability") == 0) {
            Capability newCapability = new Capability();
            try {
                newCapability.setName(node.getAttributes().getNamedItem("name").getNodeValue());
            }
            catch (NullPointerException e) {
                this.m_logger.error((CharSequence)"attribute \"name\" is missing in obr.xml in a \"capability\" tag");
                e.printStackTrace();
            }
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                PElement p = new PElement();
                Node n = list.item(i);
                Node item = null;
                if (n.getNodeName().compareTo("p") != 0) continue;
                p.setN(n.getAttributes().getNamedItem("n").getNodeValue());
                item = n.getAttributes().getNamedItem("t");
                if (item != null) {
                    p.setT(item.getNodeValue());
                }
                if ((item = n.getAttributes().getNamedItem("v")) != null) {
                    p.setV(item.getNodeValue());
                }
                newCapability.addP(p);
            }
            this.m_resourceBundle.addCapability(newCapability);
        } else if (node.getNodeName().compareTo("category") == 0) {
            Category newCategory = new Category();
            newCategory.setId(node.getAttributes().getNamedItem("id").getNodeValue());
            this.m_resourceBundle.addCategory(newCategory);
        } else {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                this.sortObrXml(list.item(i));
            }
        }
    }

    private void writeToFile(URI outputFilename, Node treeToBeWrite) throws MojoExecutionException {
        Transformer transformer = null;
        TransformerFactory tfabrique = TransformerFactory.newInstance();
        try {
            transformer = tfabrique.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.m_logger.error((CharSequence)("Unable to write to file: " + outputFilename.toString()));
            e.printStackTrace();
            throw new MojoExecutionException("TransformerConfigurationException");
        }
        Properties proprietes = new Properties();
        proprietes.put("method", "xml");
        proprietes.put("version", "1.0");
        proprietes.put("encoding", "ISO-8859-1");
        proprietes.put("standalone", "yes");
        proprietes.put("indent", "yes");
        proprietes.put("omit-xml-declaration", "no");
        transformer.setOutputProperties(proprietes);
        DOMSource input = new DOMSource(treeToBeWrite);
        File fichier = new File(outputFilename);
        fichier.getParentFile().mkdirs();
        FileOutputStream flux = null;
        try {
            flux = new FileOutputStream(fichier);
        }
        catch (FileNotFoundException e) {
            this.m_logger.error((CharSequence)("Unable to write to file: " + fichier.getName()));
            e.printStackTrace();
            throw new MojoExecutionException("FileNotFoundException");
        }
        StreamResult output = new StreamResult(flux);
        try {
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new MojoExecutionException("TransformerException");
        }
        try {
            flux.flush();
            flux.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException("IOException");
        }
    }

    private boolean walkOnTree(Node node) {
        NodeList list;
        if (node.getNodeName().compareTo("resource") == 0) {
            return this.resource(node);
        }
        if (node.getNodeName().compareTo("repository") == 0) {
            Date d = new Date();
            d.setTime(System.currentTimeMillis());
            NamedNodeMap nList = node.getAttributes();
            Node n = nList.getNamedItem("lastmodified");
            n.setNodeValue(m_format.format(d));
        }
        if ((list = node.getChildNodes()).getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                if (!this.walkOnTree(list.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void searchRepository(Node node, String id) {
        if (node.getNodeName().compareTo("repository") == 0) {
            node.appendChild(this.m_resourceBundle.getNode(this.m_repositoryDoc));
            return;
        }
        this.m_logger.info((CharSequence)"Second branch...");
        NodeList list = node.getChildNodes();
        if (list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                this.searchRepository(list.item(i), id);
            }
        }
    }

    private boolean resource(Node node) {
        String id = node.getAttributes().getNamedItem("id").getNodeValue();
        NamedNodeMap map = node.getAttributes();
        if (this.m_resourceBundle.isSameBundleResource(map.getNamedItem("symbolicname").getNodeValue(), map.getNamedItem("version").getNodeValue())) {
            this.m_resourceBundle.setId(String.valueOf(id));
            node.getParentNode().replaceChild(this.m_resourceBundle.getNode(this.m_repositoryDoc), node);
            return true;
        }
        return false;
    }
}

