/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffUniGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;

public class DefaultSVNDiffGenerator
implements ISVNDiffGenerator {
    protected static final byte[] PROPERTIES_SEPARATOR = "___________________________________________________________________".getBytes();
    protected static final byte[] HEADER_SEPARATOR = "===================================================================".getBytes();
    protected static final byte[] EOL = SVNTranslator.getEOL("native");
    protected static final String WC_REVISION_LABEL = "(working copy)";
    protected static final InputStream EMPTY_FILE_IS = SVNFileUtil.DUMMY_IN;
    private boolean myIsForcedBinaryDiff;
    private String myAnchorPath1 = "";
    private String myAnchorPath2 = "";
    private String myEncoding;
    private boolean myIsDiffDeleted = true;
    private boolean myIsDiffAdded;
    private boolean myIsDiffCopied;
    private File myBasePath;
    private boolean myIsDiffUnversioned;
    private SVNDiffOptions myDiffOptions;

    public void init(String anchorPath1, String anchorPath2) {
        this.myAnchorPath1 = anchorPath1.replace(File.separatorChar, '/');
        this.myAnchorPath2 = anchorPath2.replace(File.separatorChar, '/');
    }

    public void setDiffOptions(SVNDiffOptions options) {
        this.myDiffOptions = options;
    }

    public void setBasePath(File basePath) {
        this.myBasePath = basePath;
    }

    public void setDiffDeleted(boolean isDiffDeleted) {
        this.myIsDiffDeleted = isDiffDeleted;
    }

    public boolean isDiffDeleted() {
        return this.myIsDiffDeleted;
    }

    public void setDiffAdded(boolean isDiffAdded) {
        this.myIsDiffAdded = isDiffAdded;
    }

    public boolean isDiffAdded() {
        return this.myIsDiffAdded;
    }

    public void setDiffCopied(boolean isDiffCopied) {
        this.myIsDiffCopied = isDiffCopied;
    }

    public boolean isDiffCopied() {
        return this.myIsDiffCopied;
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    protected String getDisplayPath(String path) {
        if (this.myBasePath == null) {
            return path;
        }
        if (path == null) {
            path = "";
        }
        if (path.indexOf("://") > 0) {
            return path;
        }
        String basePath = this.myBasePath.getAbsolutePath().replace(File.separatorChar, '/');
        if (path.equals(basePath)) {
            return ".";
        }
        if (path.startsWith(basePath + "/") && (path = path.substring(basePath.length() + 1)).startsWith("./")) {
            path = path.substring("./".length());
        }
        return path;
    }

    public void setForcedBinaryDiff(boolean forced) {
        this.myIsForcedBinaryDiff = forced;
    }

    public boolean isForcedBinaryDiff() {
        return this.myIsForcedBinaryDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayPropDiff(String path, Map baseProps, Map diff, OutputStream result) throws SVNException {
        baseProps = baseProps != null ? baseProps : Collections.EMPTY_MAP;
        diff = diff != null ? diff : Collections.EMPTY_MAP;
        Iterator changedPropNames = diff.keySet().iterator();
        while (changedPropNames.hasNext()) {
            String name = (String)changedPropNames.next();
            String originalValue = (String)baseProps.get(name);
            String newValue = (String)diff.get(name);
            if ((originalValue == null || !originalValue.equals(newValue)) && originalValue != newValue) continue;
            changedPropNames.remove();
        }
        if (diff.isEmpty()) {
            return;
        }
        path = this.getDisplayPath(path);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        diff = new TreeMap(diff);
        try {
            bos.write(EOL);
            bos.write(("Property changes on: " + (this.useLocalFileSeparatorChar() ? path.replace('/', File.separatorChar) : path)).getBytes(this.getEncoding()));
            bos.write(EOL);
            bos.write(PROPERTIES_SEPARATOR);
            bos.write(EOL);
            for (String name : diff.keySet()) {
                String originalValue = baseProps != null ? (String)baseProps.get(name) : null;
                String newValue = (String)diff.get(name);
                bos.write(("Name: " + name).getBytes(this.getEncoding()));
                bos.write(EOL);
                if (originalValue != null) {
                    bos.write("   - ".getBytes(this.getEncoding()));
                    bos.write(originalValue.getBytes(this.getEncoding()));
                    bos.write(EOL);
                }
                if (newValue == null) continue;
                bos.write("   + ".getBytes(this.getEncoding()));
                bos.write(newValue.getBytes(this.getEncoding()));
                bos.write(EOL);
            }
            bos.write(EOL);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        finally {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException e) {}
        }
    }

    protected File getBasePath() {
        return this.myBasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFileDiff(String path, File file1, File file2, String rev1, String rev2, String mimeType1, String mimeType2, OutputStream result) throws SVNException {
        String header;
        SVNErrorMessage err;
        int i;
        path = this.getDisplayPath(path);
        for (i = 0; i < this.myAnchorPath1.length() && i < this.myAnchorPath2.length() && this.myAnchorPath1.charAt(i) == this.myAnchorPath2.charAt(i); ++i) {
        }
        if (i < this.myAnchorPath1.length() || i < this.myAnchorPath2.length()) {
            if (i == this.myAnchorPath1.length()) {
                i = this.myAnchorPath1.length() - 1;
            }
            while (i > 0 && this.myAnchorPath1.charAt(i) != '/') {
                --i;
            }
        }
        String p1 = this.myAnchorPath1.substring(i);
        String p2 = this.myAnchorPath2.substring(i);
        p1 = p1.length() == 0 ? path : (p1.charAt(0) == '/' ? path + "\t(..." + p1 + ")" : path + "\t(.../" + p1 + ")");
        p2 = p2.length() == 0 ? path : (p2.charAt(0) == '/' ? path + "\t(..." + p2 + ")" : path + "\t(.../" + p2 + ")");
        rev1 = rev1 == null ? WC_REVISION_LABEL : rev1;
        rev2 = rev2 == null ? WC_REVISION_LABEL : rev2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (this.displayHeader(bos, path, file2 == null)) {
                bos.close();
                bos.writeTo(result);
                return;
            }
            if (this.isHeaderForced(file1, file2)) {
                bos.writeTo(result);
                bos.reset();
            }
        }
        catch (IOException e) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException inner) {
                // empty catch block
            }
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        if (!this.isForcedBinaryDiff() && (SVNProperty.isBinaryMimeType(mimeType1) || SVNProperty.isBinaryMimeType(mimeType2))) {
            try {
                this.displayBinary(bos, mimeType1, mimeType2);
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
            }
            finally {
                try {
                    bos.close();
                    bos.writeTo(result);
                }
                catch (IOException e) {}
            }
            return;
        }
        if (file1 == file2 && file1 == null) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        try {
            this.displayHeaderFields(bos, p1, rev1, p2, rev2);
        }
        catch (IOException e) {
            try {
                bos.close();
                bos.writeTo(result);
            }
            catch (IOException inner) {
                // empty catch block
            }
            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
        try {
            bos.close();
            header = bos.toString();
        }
        catch (IOException inner) {
            header = "";
        }
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            is1 = file1 == null ? EMPTY_FILE_IS : SVNFileUtil.openFileForReading(file1);
            is2 = file2 == null ? EMPTY_FILE_IS : SVNFileUtil.openFileForReading(file2);
            QDiffUniGenerator.setup();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
            if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                properties.put("ignore-space", "all-space");
            } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                properties.put("ignore-space", "space-change");
            }
            QDiffUniGenerator generator = new QDiffUniGenerator(properties, header);
            OutputStreamWriter writer = new OutputStreamWriter(result, this.getEncoding());
            QDiffManager.generateTextDiff(is1, is2, this.getEncoding(), writer, generator);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err2, e);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(is1);
                SVNFileUtil.closeFile(is2);
                throw throwable;
            }
            SVNFileUtil.closeFile(is1);
            SVNFileUtil.closeFile(is2);
        }
        SVNFileUtil.closeFile(is1);
        SVNFileUtil.closeFile(is2);
    }

    public void setEncoding(String encoding) {
        this.myEncoding = encoding;
    }

    public String getEncoding() {
        if (this.myEncoding != null) {
            return this.myEncoding;
        }
        return System.getProperty("file.encoding");
    }

    public File createTempDirectory() throws SVNException {
        return SVNFileUtil.createTempDirectory("diff");
    }

    public boolean isDiffUnversioned() {
        return this.myIsDiffUnversioned;
    }

    public void setDiffUnversioned(boolean diffUnversioned) {
        this.myIsDiffUnversioned = diffUnversioned;
    }

    public void displayDeletedDirectory(String path, String rev1, String rev2) throws SVNException {
    }

    public void displayAddedDirectory(String path, String rev1, String rev2) throws SVNException {
    }

    protected void displayBinary(OutputStream os, String mimeType1, String mimeType2) throws IOException {
        os.write("Cannot display: file marked as a binary type.".getBytes(this.getEncoding()));
        os.write(EOL);
        if (SVNProperty.isBinaryMimeType(mimeType1) && !SVNProperty.isBinaryMimeType(mimeType2)) {
            os.write("svn:mime-type = ".getBytes(this.getEncoding()));
            os.write(mimeType1.getBytes(this.getEncoding()));
            os.write(EOL);
        } else if (!SVNProperty.isBinaryMimeType(mimeType1) && SVNProperty.isBinaryMimeType(mimeType2)) {
            os.write("svn:mime-type = ".getBytes(this.getEncoding()));
            os.write(mimeType2.getBytes(this.getEncoding()));
            os.write(EOL);
        } else if (SVNProperty.isBinaryMimeType(mimeType1) && SVNProperty.isBinaryMimeType(mimeType2)) {
            if (mimeType1.equals(mimeType2)) {
                os.write("svn:mime-type = ".getBytes(this.getEncoding()));
                os.write(mimeType2.getBytes(this.getEncoding()));
                os.write(EOL);
            } else {
                os.write("svn:mime-type = (".getBytes(this.getEncoding()));
                os.write(mimeType1.getBytes(this.getEncoding()));
                os.write(", ".getBytes(this.getEncoding()));
                os.write(mimeType2.getBytes(this.getEncoding()));
                os.write(")".getBytes(this.getEncoding()));
                os.write(EOL);
            }
        }
    }

    protected boolean displayHeader(OutputStream os, String path, boolean deleted) throws IOException {
        if (deleted && !this.isDiffDeleted()) {
            os.write("Index: ".getBytes(this.getEncoding()));
            os.write(path.getBytes(this.getEncoding()));
            os.write(" (deleted)".getBytes(this.getEncoding()));
            os.write(EOL);
            os.write(HEADER_SEPARATOR);
            os.write(EOL);
            return true;
        }
        os.write("Index: ".getBytes(this.getEncoding()));
        os.write(path.getBytes(this.getEncoding()));
        os.write(EOL);
        os.write(HEADER_SEPARATOR);
        os.write(EOL);
        return false;
    }

    protected void displayHeaderFields(OutputStream os, String path1, String rev1, String path2, String rev2) throws IOException {
        os.write("--- ".getBytes(this.getEncoding()));
        os.write(path1.getBytes(this.getEncoding()));
        os.write("\t".getBytes(this.getEncoding()));
        os.write(rev1.getBytes(this.getEncoding()));
        os.write(EOL);
        os.write("+++ ".getBytes(this.getEncoding()));
        os.write(path2.getBytes(this.getEncoding()));
        os.write("\t".getBytes(this.getEncoding()));
        os.write(rev2.getBytes(this.getEncoding()));
        os.write(EOL);
    }

    protected boolean isHeaderForced(File file1, File file2) {
        return file1 == null && file2 != null;
    }

    protected boolean useLocalFileSeparatorChar() {
        return true;
    }
}

