/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLogRunner;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public abstract class SVNLog {
    public static final String DELETE_ENTRY = "delete-entry";
    public static final String MODIFY_ENTRY = "modify-entry";
    public static final String MODIFY_WC_PROPERTY = "modify-wcprop";
    public static final String DELETE_LOCK = "delete-lock";
    public static final String MOVE = "mv";
    public static final String APPEND = "append";
    public static final String DELETE = "rm";
    public static final String READONLY = "readonly";
    public static final String COPY_AND_TRANSLATE = "cp-and-translate";
    public static final String COPY_AND_DETRANSLATE = "cp-and-detranslate";
    public static final String COPY = "cp";
    public static final String MERGE = "merge";
    public static final String MAYBE_READONLY = "maybe-readonly";
    public static final String SET_TIMESTAMP = "set-timestamp";
    public static final String COMMIT = "committed";
    public static final String UPGRADE_FORMAT = "upgrade-format";
    public static final String NAME_ATTR = "name";
    public static final String PROPERTY_NAME_ATTR = "propname";
    public static final String PROPERTY_VALUE_ATTR = "propval";
    public static final String DEST_ATTR = "dest";
    public static final String TIMESTAMP_ATTR = "timestamp";
    public static final String REVISION_ATTR = "revision";
    public static final String FORMAT_ATTR = "format";
    public static final String ATTR1 = "arg1";
    public static final String ATTR2 = "arg2";
    public static final String ATTR3 = "arg3";
    public static final String ATTR4 = "arg4";
    public static final String ATTR5 = "arg5";
    public static final String ATTR6 = "arg6";
    public static final String WC_TIMESTAMP = "working";
    protected Collection myCache;
    protected SVNAdminArea myAdminArea;

    public abstract void save() throws SVNException;

    public abstract String toString();

    public abstract void delete() throws SVNException;

    public abstract boolean exists();

    protected SVNLog(SVNAdminArea adminArea) {
        this.myAdminArea = adminArea;
    }

    public void addCommand(String name, Map attributes, boolean save) throws SVNException {
        if (this.myCache == null) {
            this.myCache = new ArrayList();
        }
        attributes = new HashMap<String, String>(attributes);
        attributes.put("", name);
        this.myCache.add(attributes);
        if (save) {
            this.save();
        }
    }

    public SVNStatusType logChangedEntryProperties(String name, Map modifiedEntryProps) throws SVNException {
        SVNStatusType status = SVNStatusType.LOCK_UNCHANGED;
        if (modifiedEntryProps != null) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put(NAME_ATTR, name);
            for (String propName : modifiedEntryProps.keySet()) {
                String propValue = (String)modifiedEntryProps.get(propName);
                String longPropName = propName;
                if (!("cachable-props".equals(propName) || "present-props".equals(propName) || "has-props".equals(propName) || "has-prop-mods".equals(propName))) {
                    longPropName = "svn:entry:" + propName;
                }
                if ("svn:entry:lock-token".equals(longPropName)) {
                    HashMap<String, String> deleteLockCommand = new HashMap<String, String>();
                    deleteLockCommand.put(NAME_ATTR, name);
                    this.addCommand(DELETE_LOCK, deleteLockCommand, false);
                    status = SVNStatusType.LOCK_UNLOCKED;
                    continue;
                }
                if (propValue == null) continue;
                command.put(propName, propValue);
            }
            this.addCommand(MODIFY_ENTRY, command, false);
            command.clear();
        }
        return status;
    }

    public void logChangedWCProperties(String name, Map modifiedWCProps) throws SVNException {
        if (modifiedWCProps != null) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put(NAME_ATTR, name);
            for (String propName : modifiedWCProps.keySet()) {
                String propValue = (String)modifiedWCProps.get(propName);
                command.put(PROPERTY_NAME_ATTR, propName);
                if (propValue != null) {
                    command.put(PROPERTY_VALUE_ATTR, propValue);
                } else {
                    command.remove(PROPERTY_VALUE_ATTR);
                }
                this.addCommand(MODIFY_WC_PROPERTY, command, false);
                command.clear();
            }
        }
    }

    public void run(SVNLogRunner runner) throws SVNException {
        Collection commands = this.readCommands();
        if (commands == null || commands.isEmpty()) {
            return;
        }
        try {
            int count = 0;
            Iterator cmds = commands.iterator();
            while (cmds.hasNext()) {
                Map command = (Map)cmds.next();
                String name = (String)command.get("");
                String attrName = (String)command.get(NAME_ATTR);
                if (attrName == null && !UPGRADE_FORMAT.equals(name)) {
                    SVNErrorCode code = count <= 1 ? SVNErrorCode.WC_BAD_ADM_LOG_START : SVNErrorCode.WC_BAD_ADM_LOG;
                    SVNErrorMessage err = SVNErrorMessage.create(code, "Log entry missing 'name' attribute (entry ''{0}'' for directory ''{1}'')", new Object[]{name, this.myAdminArea.getRoot()});
                    SVNErrorManager.error(err);
                }
                if (runner != null) {
                    runner.runCommand(this.myAdminArea, name, command, ++count);
                }
                cmds.remove();
            }
        }
        catch (SVNException e) {
            this.myCache = null;
            for (Map command : commands) {
                String name = (String)command.remove("");
                this.addCommand(name, command, false);
            }
            this.save();
            throw e;
        }
    }

    protected abstract Collection readCommands() throws SVNException;
}

