/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-reactor", threadSafe=true)
public class UseReactorMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Inject
    public UseReactorMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        try {
            DependencyManagement dependencyManagement;
            if (this.isProcessingParent() && this.getProject().hasParent()) {
                this.useReactor(pom, this.getProject().getParent());
            }
            if (this.isProcessingDependencyManagement() && (dependencyManagement = PomHelper.getRawModel((MavenProject)this.getProject()).getDependencyManagement()) != null) {
                this.useReactor(pom, dependencyManagement.getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useReactor(pom, this.getProject().getDependencies());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void useReactor(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, VersionRetrievalException {
        block0: for (Dependency dep : dependencies) {
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            for (MavenProject reactorProject : this.reactorProjects) {
                MavenProject project = reactorProject;
                if (!StringUtils.equals((CharSequence)project.getGroupId(), (CharSequence)dep.getGroupId()) || !StringUtils.equals((CharSequence)project.getArtifactId(), (CharSequence)dep.getArtifactId()) || StringUtils.equals((CharSequence)project.getVersion(), (CharSequence)dep.getVersion())) continue;
                if (!PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)pom, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)dep.getVersion(), (String)project.getVersion(), (Model)this.getProject().getModel())) continue block0;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + project.getVersion()));
                continue block0;
            }
        }
    }

    private void useReactor(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, VersionRetrievalException {
        for (MavenProject project : this.reactorProjects) {
            if (!StringUtils.equals((CharSequence)project.getGroupId(), (CharSequence)parent.getGroupId()) || !StringUtils.equals((CharSequence)project.getArtifactId(), (CharSequence)parent.getArtifactId()) || StringUtils.equals((CharSequence)project.getVersion(), (CharSequence)parent.getVersion()) || !PomHelper.setProjectParentVersion((ModifiedPomXMLEventReader)pom, (String)project.getVersion())) continue;
            this.getLog().info((CharSequence)("Updated parent " + this.toString(parent) + " to version " + project.getVersion()));
        }
    }
}

