/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.jetty;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.glassfish.jersey.test.spi.TestHelper;

public class JettyTestContainerFactory
implements TestContainerFactory {
    public TestContainer create(URI baseUri, DeploymentContext context) throws IllegalArgumentException {
        return new JettyTestContainer(baseUri, context);
    }

    private static class JettyTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(JettyTestContainer.class.getName());
        private URI baseUri;
        private final Server server;

        private JettyTestContainer(URI baseUri, DeploymentContext context) {
            URI base = UriBuilder.fromUri((URI)baseUri).path(context.getContextPath()).build(new Object[0]);
            if (!"/".equals(base.getRawPath())) {
                throw new TestContainerException(String.format("Cannot deploy on %s. Jetty HTTP container only supports deployment on root path.", base.getRawPath()));
            }
            this.baseUri = base;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Creating JettyTestContainer configured at the base URI " + TestHelper.zeroPortToAvailablePort((URI)baseUri));
            }
            this.server = JettyHttpContainerFactory.createServer((URI)this.baseUri, (ResourceConfig)context.getResourceConfig(), (boolean)false);
        }

        public ClientConfig getClientConfig() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.WARNING, "Ignoring start request - JettyTestContainer is already started.");
            } else {
                LOGGER.log(Level.FINE, "Starting JettyTestContainer...");
                try {
                    this.server.start();
                    if (this.baseUri.getPort() == 0) {
                        int port = 0;
                        for (Connector connector : this.server.getConnectors()) {
                            if (!(connector instanceof ServerConnector)) continue;
                            port = ((ServerConnector)connector).getLocalPort();
                            break;
                        }
                        this.baseUri = UriBuilder.fromUri((URI)this.baseUri).port(port).build(new Object[0]);
                        LOGGER.log(Level.INFO, "Started JettyTestContainer at the base URI " + this.baseUri);
                    }
                }
                catch (Exception e) {
                    throw new TestContainerException((Throwable)e);
                }
            }
        }

        public void stop() {
            if (this.server.isStarted()) {
                LOGGER.log(Level.FINE, "Stopping JettyTestContainer...");
                try {
                    this.server.stop();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error Stopping JettyTestContainer...", ex);
                }
            } else {
                LOGGER.log(Level.WARNING, "Ignoring stop request - JettyTestContainer is already stopped.");
            }
        }
    }
}

