/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.header.AuthenticationInfoHeader;

public final class AuthenticationInfo
extends ParametersHeader
implements AuthenticationInfoHeader {
    private static final long serialVersionUID = -4371927900917127057L;
    private String scheme;

    public AuthenticationInfo() {
        super("Authentication-Info");
        this.parameters.setSeparator(",");
    }

    public void add(NameValue nv) {
        this.parameters.set(nv);
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        if (this.scheme != null) {
            buffer.append(this.scheme).append(' ');
        }
        return this.parameters.encode(buffer);
    }

    public NameValue getAuthInfo(String name) {
        return this.parameters.getNameValue(name);
    }

    public String getAuthenticationInfo() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    public String getCNonce() {
        return this.getParameter("cnonce");
    }

    public String getNextNonce() {
        return this.getParameter("nextnonce");
    }

    public int getNonceCount() {
        return this.getParameterAsInt("nc");
    }

    public String getQop() {
        return this.getParameter("qop");
    }

    public String getResponse() {
        return this.getParameter("rspauth");
    }

    public String getSNum() {
        return this.getParameter("snum");
    }

    public String getSRand() {
        return this.getParameter("srand");
    }

    public String getTargetName() {
        return this.getParameter("targetname");
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setCNonce(String cNonce) throws ParseException {
        this.setParameter("cnonce", cNonce);
    }

    public void setNextNonce(String nextNonce) throws ParseException {
        this.setParameter("nextnonce", nextNonce);
    }

    public void setNonceCount(int nonceCount) throws ParseException {
        if (nonceCount < 0) {
            throw new ParseException("bad value", 0);
        }
        String nc = Integer.toHexString(nonceCount);
        String base = "00000000";
        nc = base.substring(0, 8 - nc.length()) + nc;
        this.setParameter("nc", nc);
    }

    public void setQop(String qop) throws ParseException {
        this.setParameter("qop", qop);
    }

    public void setResponse(String response) throws ParseException {
        this.setParameter("rspauth", response);
    }

    public void setSNum(String sNum) throws ParseException {
        this.setParameter("snum", sNum);
    }

    public void setSRand(String sRand) throws ParseException {
        this.setParameter("srand", sRand);
    }

    public void setTargetName(String targetName) throws ParseException {
        this.setParameter("targetname", targetName);
    }

    public void setScheme(String scheme) throws ParseException {
        this.scheme = scheme;
    }

    @Override
    public void setParameter(String name, String value) throws ParseException {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        NameValue nv = this.parameters.getNameValue(name.toLowerCase());
        if (nv == null) {
            nv = new NameValue(name, value);
            if (name.equalsIgnoreCase("qop") || name.equalsIgnoreCase("nextnonce") || name.equalsIgnoreCase("realm") || name.equalsIgnoreCase("cnonce") || name.equalsIgnoreCase("nonce") || name.equalsIgnoreCase("opaque") || name.equalsIgnoreCase("username") || name.equalsIgnoreCase("domain") || name.equalsIgnoreCase("nextnonce") || name.equalsIgnoreCase("rspauth") || name.equalsIgnoreCase("srand") || name.equalsIgnoreCase("snum") || name.equalsIgnoreCase("targetname")) {
                if (value == null) {
                    throw new NullPointerException("null value");
                }
                if (value.startsWith("\"")) {
                    throw new ParseException(value + " : Unexpected DOUBLE_QUOTE", 0);
                }
                nv.setQuotedValue();
            }
            super.setParameter(nv);
        } else {
            nv.setValueAsObject(value);
        }
    }
}

