/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.PatchFailedException;
import java.util.List;
import java.util.Objects;

public abstract class Delta<T> {
    private final DeltaType deltaType;
    private final Chunk<T> original;
    private final Chunk<T> revised;

    public Delta(DeltaType deltaType, Chunk<T> original, Chunk<T> revised) {
        Objects.requireNonNull(deltaType, "deltaType must not be null");
        Objects.requireNonNull(original, "original must not be null");
        Objects.requireNonNull(revised, "revised must not be null");
        this.deltaType = deltaType;
        this.original = original;
        this.revised = revised;
    }

    public void verify(List<T> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public abstract void applyTo(List<T> var1) throws PatchFailedException;

    public abstract void restore(List<T> var1);

    public final DeltaType getType() {
        return this.deltaType;
    }

    public Chunk<T> getOriginal() {
        return this.original;
    }

    public Chunk<T> getRevised() {
        return this.revised;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.revised == null ? 0 : this.revised.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Delta other = (Delta)obj;
        if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
            return false;
        }
        return !(this.revised == null ? other.revised != null : !this.revised.equals(other.revised));
    }
}

