/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib;

import com.github.difflib.algorithm.DiffAlgorithm;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.algorithm.myers.MyersDiff;
import com.github.difflib.patch.Delta;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class DiffUtils {
    public static <T> Patch<T> diff(List<T> original, List<T> revised) throws DiffException {
        return DiffUtils.diff(original, revised, new MyersDiff());
    }

    public static Patch<String> diff(String originalText, String revisedText) throws DiffException {
        return DiffUtils.diff(Arrays.asList(originalText.split("\n")), Arrays.asList(revisedText.split("\n")));
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, BiPredicate<T, T> equalizer) throws DiffException {
        if (equalizer != null) {
            return DiffUtils.diff(original, revised, new MyersDiff<T>(equalizer));
        }
        return DiffUtils.diff(original, revised, new MyersDiff());
    }

    public static <T> Patch<T> diff(List<T> original, List<T> revised, DiffAlgorithm<T> algorithm) throws DiffException {
        Objects.requireNonNull(original, "original must not be null");
        Objects.requireNonNull(revised, "revised must not be null");
        Objects.requireNonNull(algorithm, "algorithm must not be null");
        return Patch.generate(original, revised, algorithm.diff(original, revised));
    }

    public static Patch<String> diffInline(String original, String revised) throws DiffException {
        Character character;
        int n;
        ArrayList<String> origList = new ArrayList<String>();
        ArrayList<String> revList = new ArrayList<String>();
        char[] cArray = original.toCharArray();
        int n2 = cArray.length;
        for (n = 0; n < n2; ++n) {
            character = Character.valueOf(cArray[n]);
            origList.add(character.toString());
        }
        cArray = revised.toCharArray();
        n2 = cArray.length;
        for (n = 0; n < n2; ++n) {
            character = Character.valueOf(cArray[n]);
            revList.add(character.toString());
        }
        Patch<String> patch = DiffUtils.diff(origList, revList);
        for (Delta delta : patch.getDeltas()) {
            delta.getOriginal().setLines(DiffUtils.compressLines(delta.getOriginal().getLines(), ""));
            delta.getRevised().setLines(DiffUtils.compressLines(delta.getRevised().getLines(), ""));
        }
        return patch;
    }

    private static List<String> compressLines(List<String> lines, String delimiter) {
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(lines.stream().collect(Collectors.joining(delimiter)));
    }

    public static <T> List<T> patch(List<T> original, Patch<T> patch) throws PatchFailedException {
        return patch.applyTo(original);
    }

    public static <T> List<T> unpatch(List<T> revised, Patch<T> patch) {
        return patch.restore(revised);
    }

    private DiffUtils() {
    }
}

