/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.format;

import java.util.Hashtable;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.utility.FormatUtils;

public class WavAudioFormat
extends AudioFormat {
    public static final int WAVE_FORMAT_PCM = 1;
    public static final int WAVE_FORMAT_ADPCM = 2;
    public static final int WAVE_FORMAT_ALAW = 6;
    public static final int WAVE_FORMAT_MULAW = 7;
    public static final int WAVE_FORMAT_OKI_ADPCM = 16;
    public static final int WAVE_FORMAT_DIGISTD = 21;
    public static final int WAVE_FORMAT_DIGIFIX = 22;
    public static final int WAVE_FORMAT_GSM610 = 49;
    public static final int WAVE_IBM_FORMAT_MULAW = 257;
    public static final int WAVE_IBM_FORMAT_ALAW = 258;
    public static final int WAVE_IBM_FORMAT_ADPCM = 259;
    public static final int WAVE_FORMAT_DVI_ADPCM = 17;
    public static final int WAVE_FORMAT_SX7383 = 7175;
    public static final int WAVE_FORMAT_DSPGROUP_TRUESPEECH = 34;
    public static final int WAVE_FORMAT_MSNAUDIO = 50;
    public static final int WAVE_FORMAT_MSG723 = 66;
    public static final int WAVE_FORMAT_MPEG_LAYER3 = 85;
    public static final int WAVE_FORMAT_VOXWARE_AC8 = 112;
    public static final int WAVE_FORMAT_VOXWARE_AC10 = 113;
    public static final int WAVE_FORMAT_VOXWARE_AC16 = 114;
    public static final int WAVE_FORMAT_VOXWARE_AC20 = 115;
    public static final int WAVE_FORMAT_VOXWARE_METAVOICE = 116;
    public static final int WAVE_FORMAT_VOXWARE_METASOUND = 117;
    public static final int WAVE_FORMAT_VOXWARE_RT29H = 118;
    public static final int WAVE_FORMAT_VOXWARE_VR12 = 119;
    public static final int WAVE_FORMAT_VOXWARE_VR18 = 120;
    public static final int WAVE_FORMAT_VOXWARE_TQ40 = 121;
    public static final int WAVE_FORMAT_VOXWARE_TQ60 = 129;
    public static final int WAVE_FORMAT_MSRT24 = 130;
    protected byte[] codecSpecificHeader;
    private int averageBytesPerSecond = -1;
    public static final Hashtable<Integer, String> formatMapper = new Hashtable();
    public static final Hashtable<String, Integer> reverseFormatMapper = new Hashtable();

    public WavAudioFormat(String encoding) {
        super(encoding);
    }

    public WavAudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int frameSizeInBits, int averageBytesPerSecond, byte[] codecSpecificHeader) {
        super(encoding, sampleRate, sampleSizeInBits, channels, -1, -1, frameSizeInBits, averageBytesPerSecond, byteArray);
        this.averageBytesPerSecond = averageBytesPerSecond;
        this.codecSpecificHeader = codecSpecificHeader;
    }

    public WavAudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int frameSizeInBits, int averageBytesPerSecond, int endian, int signed, float frameRate, Class<?> dataType, byte[] codecSpecificHeader) {
        super(encoding, sampleRate, sampleSizeInBits, channels, endian, signed, frameSizeInBits, averageBytesPerSecond, dataType);
        this.averageBytesPerSecond = averageBytesPerSecond;
        this.codecSpecificHeader = codecSpecificHeader;
    }

    @Override
    public Object clone() {
        return new WavAudioFormat(this.encoding, this.sampleRate, this.sampleSizeInBits, this.channels, this.frameSizeInBits, this.averageBytesPerSecond, this.endian, this.signed, (float)this.frameRate, this.dataType, this.codecSpecificHeader);
    }

    @Override
    protected void copy(Format f) {
        super.copy(f);
        WavAudioFormat oCast = (WavAudioFormat)f;
        this.averageBytesPerSecond = oCast.averageBytesPerSecond;
        this.codecSpecificHeader = oCast.codecSpecificHeader;
    }

    @Override
    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof WavAudioFormat)) {
            return false;
        }
        WavAudioFormat oCast = (WavAudioFormat)format;
        return this.averageBytesPerSecond == oCast.averageBytesPerSecond && this.codecSpecificHeader == oCast.codecSpecificHeader;
    }

    public int getAverageBytesPerSecond() {
        return this.averageBytesPerSecond;
    }

    public byte[] getCodecSpecificHeader() {
        return this.codecSpecificHeader;
    }

    @Override
    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof WavAudioFormat) {
            WavAudioFormat resultCast = (WavAudioFormat)result;
            WavAudioFormat oCast = (WavAudioFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass())) {
                if (FormatUtils.specified(this.averageBytesPerSecond)) {
                    resultCast.averageBytesPerSecond = this.averageBytesPerSecond;
                }
                if (FormatUtils.specified(this.codecSpecificHeader)) {
                    resultCast.codecSpecificHeader = this.codecSpecificHeader;
                }
            } else if (other.getClass().isAssignableFrom(this.getClass())) {
                if (!FormatUtils.specified(resultCast.averageBytesPerSecond)) {
                    resultCast.averageBytesPerSecond = oCast.averageBytesPerSecond;
                }
                if (!FormatUtils.specified(resultCast.codecSpecificHeader)) {
                    resultCast.codecSpecificHeader = oCast.codecSpecificHeader;
                }
            }
        }
        return result;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof WavAudioFormat)) {
            return true;
        }
        WavAudioFormat oCast = (WavAudioFormat)format;
        return FormatUtils.matches(this.averageBytesPerSecond, oCast.averageBytesPerSecond) && FormatUtils.matches(this.codecSpecificHeader, oCast.codecSpecificHeader);
    }

    static {
        formatMapper.put(1, "LINEAR");
        formatMapper.put(2, "msadpcm");
        formatMapper.put(6, "alaw");
        formatMapper.put(7, "ULAW");
        formatMapper.put(17, "ima4/ms");
        formatMapper.put(34, "truespeech");
        formatMapper.put(49, "gsm/ms");
        formatMapper.put(50, "msnaudio");
        formatMapper.put(85, "mpeglayer3");
        formatMapper.put(112, "voxwareac8");
        formatMapper.put(113, "voxwareac10");
        formatMapper.put(114, "voxwareac16");
        formatMapper.put(115, "voxwareac20");
        formatMapper.put(116, "voxwaremetavoice");
        formatMapper.put(117, "voxwaremetasound");
        formatMapper.put(118, "voxwarert29h");
        formatMapper.put(119, "voxwarevr12");
        formatMapper.put(120, "voxwarevr18");
        formatMapper.put(121, "voxwaretq40");
        formatMapper.put(129, "voxwaretq60");
        formatMapper.put(130, "msrt24");
        reverseFormatMapper.put("alaw", 6);
        reverseFormatMapper.put("gsm/ms", 49);
        reverseFormatMapper.put("ima4/ms", 17);
        reverseFormatMapper.put("linear", 1);
        reverseFormatMapper.put("mpeglayer3", 85);
        reverseFormatMapper.put("msadpcm", 2);
        reverseFormatMapper.put("msnaudio", 50);
        reverseFormatMapper.put("msrt24", 130);
        reverseFormatMapper.put("truespeech", 34);
        reverseFormatMapper.put("ulaw", 7);
        reverseFormatMapper.put("voxwareac10", 113);
        reverseFormatMapper.put("voxwareac16", 114);
        reverseFormatMapper.put("voxwareac20", 115);
        reverseFormatMapper.put("voxwareac8", 112);
        reverseFormatMapper.put("voxwaremetasound", 117);
        reverseFormatMapper.put("voxwaremetavoice", 116);
        reverseFormatMapper.put("voxwarert29h", 118);
        reverseFormatMapper.put("voxwaretq40", 121);
        reverseFormatMapper.put("voxwaretq60", 129);
        reverseFormatMapper.put("voxwarevr12", 119);
        reverseFormatMapper.put("voxwarevr18", 120);
    }
}

